# People Component

Displays a navigable sequence of users at a random index into the full list of
users.

## Installation

Save the content of this repository into the `web/intranet/peoplecomponent`
directory of your Claromentis instance.

## Usage

```html
<component class="\Claromentis\Peoplecomponent\PeopleComponent">
```

### Attributes

All attributes for this component are optional.

- **metadata** (str) - A user metadata key. If used, the text value of
  that metadata, if it exists, will be retrieved and displayed. Note that
  metadata values longer that 40 characters will be truncated

- **limit** (int) - The number of users to display at once (defaults to 2). 
  If set to more than 3, the following users will stack below in a new row. 

- **random** (bool) - If set to anything other than `"false"`, the ordering of
  users will be randomized, as opposed to the default alphabetic ordering

- **date_started_metadata** (string) - Only shows users with a `date_started`
  metadata value that's within the given number of days from the current date.
  Default value is `usr_date_started`. *Please ensure this metadata is of the __Date__ type.*
  
- **probation** (int) - Only shows users with a value of metadata specified in
  `date_started_metadata` attribute that's within the given number of days from 
  the current date.
  
- **groups** (str) - A comma separated string of group ids. This will limit the
	people component to only users within these groups. (excluding child groups)
	
- **groups_plus** (str) - A comma separated string of group ids. This will limit the
	people component to users within these groups, including all child groups, recursively.
	

