/** People list jQuery plugin*/
define(['jquery', './spin.min.js'], function ($, Spinner) {
    $.fn.peoplelist = function (options) {

        var container = $(this);
        var component = container.parent('.people-component');
        var settings = $.extend({}, options);

        var card_template    = require('../../html/tmpl/people_card.tmpl');
        var table_template   = require('../../html/tmpl/people_table.tmpl');

        function getList(item, $list) {
            if ($.isArray(item)) {
                $.each(item, function (key, value) {
                    getList(value, $list);
                });

                return;
            }

            if (item) {
                var $userItem = $('<div />');
                $($userItem).addClass('col-user')
                var $info = container.find('.people-info');

                if (item.profile_url) {
                    item.show_job_title = show_job_title;
                    item.show_email_address = show_email_address;
                    $userItem.append(card_template(item));
                }

                $list.append($userItem)
            }
        }

        function fetch(q, index, limit, metadata, date_started_metadata, show_admin, sort_order, probation, exclude_future_starts, groups, groups_plus, roles, mode, headers, group_names, load_type) {
            spinner.spin(target);

            var options = {
                'q': q,
                'index': index,
                'limit': limit,
                'date_started_metadata': date_started_metadata,
                'show_admin': show_admin == 1,
                'sort_order': sort_order,
                'probation': probation,
                'exclude_future_starts' : exclude_future_starts,
                'groups': groups,
                'groups_plus': groups_plus,
                'roles': roles,
                'mode': mode
            };

            if (Array.isArray(metadata)) {
                options['metadata_attribute'] = JSON.stringify(metadata);
            } else {
                options['metadata_attribute'] = metadata;
            }

            $.get('/intranet/peoplecomponent/ajax.php', options).done(function (result) {
                var json = jQuery.parseJSON(result);
                if (mode === "card") {
                    // Allow going to a previous page if there are less than <users-per-page> people left
                    json.previous = (json.previous < 0 && json.previous > -limit) ? 0 : json.previous;

                    container.find('.load-more').attr('data-index', json.next);

                    if (json.next === 0) {
                        container.find('.load-more').hide();
                    } else {
                        container.find('.load-more').show();
                    }

                    var count = json.data.length;
                } else {
                    container.find('.load-more').hide();
                }
                //don't show the footer if there are no other people to display
                var showFooter = !(json.next === 0 && json.previous <= 0);
                drawList(json.data, count, metadata, mode, headers, showFooter, load_type);
                spinner.stop();
            });
        }

        function drawList(data, count, metadata, mode, headers, showFooter, load_type) {
            var listContainer;

            if (mode === "card") {
                if (load_type === 'load_more') {
                    getList(data, container.find('.row-user'));
                } else {
                    listContainer = $('<div class="row-user pages-card-grid my-3"></div>');
                    getList(data, listContainer);
                }


            } else if (mode === "list") {
                var query = "";
                name_array = JSON.parse(group_names);

                if (name_array.length > 0) {
                    name_array = name_array.map(function (elem) {
                        return '"' + elem + '"';});
                    query = name_array.join(",");
                    if (name_array.length > 1)
                        query = "(" + query + ")";
                    query = "Group:" + query;

                    if (groups_plus !== "")
                        query += " +groups";

                    query = encodeURIComponent(query);

                    query = "?search_terms=" + query;

                }

                var table_code = table_template({metadata: headers, show_job_title: show_job_title, show_email_address: show_email_address, query_string: query, users:data, show_footer: showFooter});
                listContainer = $(table_code);


            }

            // Reloads page if searching and loading and appends if loading more items
            const dynamicContainer = container.find('.dynamic-content');
            if (load_type !== 'load_more') {
                dynamicContainer.html(listContainer);
            }

            // Hides the people list table if there are no users in the search
            const peopleTable = document.getElementById('table-people-component');

            if (peopleTable != null) {
                if (data.length === 0) {
                    peopleTable.classList.add('d-none');
                } else {
                    peopleTable.classList.remove('d-none');
                }
            }

        }

        $(this).prepend('<div class="dynamic-content-wrapper"><div class="dynamic-content"></div></div>');
        $(this).prepend('<div class="js-peoplelist-spinner"></div>');

        // Only add search bar if show_search is enabled
        var show_search = parseInt(component.find('input[name=show_search]').val());
        if (show_search === 1) {
            $(this).prepend('<input type="text" id="peoplelist-search" class="form-control mb-3 w-100" placeholder="' + settings.txt_search_people + '">');
        }

        //spinner
        var opts = {
            lines: 11, // The number of lines to draw
            length: 9, // The length of each line
            width: 3, // The line thickness
            radius: 8, // The radius of the inner circle
            corners: 0.8, // Corner roundness (0..1)
            rotate: 34, // The rotation offset
            direction: 1, // 1: clockwise, -1: counterclockwise
            color: '#000', // #rgb or #rrggbb or array of colors
            speed: 1, // Rounds per second
            trail: 52, // Afterglow percentage
            shadow: false, // Whether to render a shadow
            hwaccel: false, // Whether to use hardware acceleration
            className: 'people-spinner', // The CSS class to assign to the spinner
            zIndex: 2e9, // The z-index (defaults to 2000000000)
            top: '25px', // Top position relative to parent
            left: '50%', // Left position relative to parent
            position: 'relative'  // element position
        };

        var target = container.find('.js-peoplelist-spinner')[0];
        var spinner = new Spinner(opts).spin(target).stop();
        var metadata_is_array = parseInt(component.find('input[name=metadata_is_array]').val());
        var metadata_attribute;
        var meta_names = [];
        if (metadata_is_array === 1) {
            metadata_attribute = JSON.parse(component.find('input[name=metadata_attribute]').val());
            meta_names = JSON.parse(component.find('input[name=metadata_names]').val());
        } else
            metadata_attribute = component.find('input[name=metadata_attribute]').val();

        var date_started_metadata = component.find('input[name=date_started_metadata]').val();
        var limit = component.find('input[name=limit]').val();
        var show_admin = component.find('input[name=show_admin]').val();
        var sort_order = component.find('input[name=sort_order]').val();
        var probation = component.find('input[name=probation]').val();
        var exclude_future_starts = component.find('input[name=exclude_future_starts]').val();
        var groups = component.find('input[name=groups]').val();
        var group_names = component.find('input[name=group_names]').val();
        var groups_plus = component.find('input[name=groups_plus]').val();
        var roles = component.find('input[name=roles]').val();
        var mode = component.find('input[name=mode]').val();
        var show_job_title = parseInt(component.find('input[name=show_job_title]').val());
        var show_email_address = parseInt(component.find('input[name=show_email_address]').val());
        var search_timer;
        var index = -1
        if(mode == "list" && sort_order == 0){
            index = 0;
        }

        // Search - only bind if the search bar is enabled
        if (show_search === 1) {
            container.find('#peoplelist-search').keyup(function (e) {
                clearTimeout(search_timer);

                search_timer = setTimeout(function () {
                    var q = $(e.target).val();
                    var index = 0;
                    container.find('.dynamic-content').empty();

                    fetch(q, index, limit, metadata_attribute, date_started_metadata, show_admin, sort_order, probation, exclude_future_starts, groups, groups_plus, roles, mode, meta_names, group_names, 'on_search');
                }, 250);
            });
        }

        //left & right buttons
        container.find('.load-more').click(function (e) {
            // Check that the search bar is enabled before getting .val
            var q = '';
            if (show_search === 1) {
                var searchInput = container.find('#peoplelist-search');
                q = searchInput ? searchInput.val() : q;
            }

            var index = $(this).attr('data-index');

            if (q.length == 0) {
                fetch('', index, limit, metadata_attribute, date_started_metadata, show_admin, sort_order, probation, exclude_future_starts, groups, groups_plus, roles, mode, meta_names, group_names, 'load_more');
            }

            if (q.length >= 3) {
                fetch(q, index, limit, metadata_attribute, date_started_metadata, show_admin, sort_order, probation, exclude_future_starts, groups, groups_plus, roles, mode, meta_names, group_names, 'load_more');
            }

            e.preventDefault();
        });

        //Init on load list
        var index = 0;
        fetch('', index, limit, metadata_attribute, date_started_metadata, show_admin, sort_order, probation, exclude_future_starts, groups, groups_plus, roles, mode, meta_names, group_names, 'on_load');

        return this;
    };
});
