<?php
$_db_migration_to = '03.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_admin_panel.php', <<<'DB_UPDATE_FILE'
<?php

/** @var $migrations Claromentis\Setup\SetupFacade */

$admin_panel = $migrations->GetAdminPanelCreator();
$admin_panel->Create('policy', '/intranet/policy/admin.php', array('name' => 'Policy Manager', 'css_class' => ''));


DB_UPDATE_FILE
);


$migrations->Run('02_cla8_admin_panel.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */

$admin_panel = $migrations->GetAdminPanelCreator();
$admin_panel->Delete('policy', true);

DB_UPDATE_FILE
);


$migrations->Run('03_reinstall_plugin.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */

// re-add plugin to make sure it's installed when Claromentis is upgraded to 8
$plugins = $migrations->GetPluginsRepository();
$plugins->Add('policy', "PolicyPlugin");

DB_UPDATE_FILE
);


$migrations->Run('05_nested_sets.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */

$db = $migrations->GetDb();

use Claromentis\Core\DAL;

$db->query("DELETE FROM nested_sets WHERE ref_table=str:table", 'policy_categories');

function policy_nested_sets_rebuild_tree(DAL\Db $db, $id, $left, $level)
{
	if ($level > 90)
		throw new \Exception("Tree seems to be too deep or broken");

	$query = new DAL\Query("SELECT t.id, ns.ref_id, ns.ns_left, ns.ns_right, ns.ns_level FROM policy_categories t, nested_sets ns WHERE t.parent=$id ORDER BY ns.ns_left");
	$query->addJoinCondition('t', 'ns', "ns.ref_id=t.id AND ns.ref_table=str:table");
	$query->Bind("table", 'policy_categories');
	$res = $db->query($query);

	$right = $left;
	while (list($real_id, $ns_id, $db_left, $db_right, $db_level) = $res->fetchRow())
	{
		$right = policy_nested_sets_rebuild_tree($db, $real_id, $left + 1, $level + 1);
		if ($ns_id && ($left != $db_left || $right != $db_right || $level != $db_level))
		{
			$q = new DAL\QueryUpdate(
				'nested_sets', "ref_id=int:id AND ref_table=str:table",
				[
					"int:ns_left" => $left,
					"int:ns_right" => $right,
					"int:ns_level" => $level,
				]
			);
			$q->Bind('id', $real_id);
			$q->Bind('table', 'policy_categories');
			$db->query($q);
		} elseif (!$ns_id)
		{
			$q = new DAL\QueryInsert(
				'nested_sets',
				[
					"int:ref_id" => $real_id,
					"str:ref_table" => 'policy_categories',
					"int:ns_left" => $left,
					"int:ns_right" => $right,
					"int:ns_level" => $level,
				]
			);
			$db->query($q);
		}
		$right ++;
		$left = $right;
	}
	return $right;
}


try
{
	policy_nested_sets_rebuild_tree($db, 0, 1, 1);
} catch (\Exception $e)
{
	$migrations->Log("ERROR: ".$e->getMessage());
}


DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('03.01');
