define(['jquery', 'cla_select2'], function(jQuery){
    return function()  {
        var page = jQuery('#page');
        if (page.length > 0 && !CKEDITOR.instances.message_body) {
            CKEDITOR.replace('message_body', {"customConfig":"/intranet/policy/assets/js/ckeditor/ckconfig_policy.js","height":400});
        }

        var policy_id = parseInt(jQuery('#related_policies_s2').data('id'));
        jQuery('#related_policies_s2').select2({
            minimumInputLength: 3,
            allowClear: true,
            placeholder: txt_select_policies,
            ajax: {
                url: '/intranet/rest/policy/policies/',
                quietMillis: 400,
                dataType: 'json',
                data: function (params) {
                    return { q:params.term, page_limit:10, page:params.page, policy: policy_id };
                },
                processResults: function (data, params)
                {
                    var more = data.total > (params.page * 10);
                    return { results:data.policies, pagination: { more:more } };
                }
            }
        });


        // Updates the values at the top of the page on load and on text input
        function autoUpdate(value, output) {
            var inputValue = jQuery(value).val();
            var outputDestination = jQuery(output);

            if (inputValue !== '') {
                outputDestination.text(inputValue);
            } else {
                if (output === '#info_title') {
                    outputDestination.html('<i class="text-muted">' + lmsg('policy.common.header.title') + '</i>');
                } else {
                    outputDestination.html('<i class="text-muted">' + lmsg('policy.common.header.ref') + '</i>');
                }
            }
        }

        autoUpdate('#title', '#info_title');
        autoUpdate('#ref_code', '#info_ref_code');

        jQuery('input[name="ref_code"]').on('keyup change', function(e) {
            autoUpdate('#ref_code', '#info_ref_code');
        });

        jQuery('input[name="title"]').on('keyup change', function(e) {
            autoUpdate('#title', '#info_title');
        });
    };
});
