<?php
$_db_migration_to = '01.09';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_policy_remove_abs_paths.php', <<<'DB_UPDATE_FILE'
<?php
$db = $migrations->GetDb();
global $DATA_DIR;

$old_path = $DATA_DIR."/docs_data/policy"; // Old path used by the police manager.
if (is_dir($old_path))
{
	$new_folder = $DATA_DIR.PolicyAttachment::POLICY_DATA_DIR;
	if (!is_dir($new_folder))
	{	// Create the new location if it doesn't exist already.
		mkdir($new_folder, 0777);
	}

	// Copy all files that may be in the old location (docs_data/policy) to the new folder and delete the old folder (PHP rename did not work).
	$objects = scandir($old_path);
	foreach ($objects as $object) {
		if ($object != "." && $object != "..") {
			copy($old_path.'/'.$object, $new_folder.'/'.$object);
			unlink($old_path.'/'.$object);
		}
	}
	reset($objects);
	rmdir($old_path);
}

// Get the ids and the paths of all file attachments in the database.
$res = $db->query("SELECT id, file_path FROM policy_attachments WHERE type=1");
$db->DisableTokenCheck();

while ($row = $res->fetchArray())
{
	$file_name = basename($row['file_path']);
	$db->query("UPDATE policy_attachments SET file_path=str:file_name WHERE id=int:policy_id", $file_name, $row['id']);
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.09');
