/**
 * An integer filter control
 *
 * @author Simon Willan <simon.willan@claromentis.com>
 */
(function () {
	'use strict';

	angular.module(ng_module_name)
		.directive('repAttachmentControl', repAttachmentControl);

	repAttachmentControl.$inject = ['$timeout'];

	function repAttachmentControl($timeout) {
		var directive = {
			bindToController: true,
			controller: controller,
			controllerAs: "filter",
			restrict: 'E',
			scope: {
				args: '='
			},
			templateUrl: '/intranet/policy/html/tmpl/reports/filters/attachment.html'
		};

		return directive;
		//////////////////

		function controller($scope, $element) {
			var ctl = this;

			ctl.change = change;

			ctl.lmsg = {
				placeholder: lmsg('policy.reports.filter.attachment_placeholder')
			};

			ctl.options = [];

			init();

			function init() {

				fill();

				$timeout(function () {
					$element.find("#assetFilter").val(ctl.args.values[0]).trigger("change");
				}, 0, true);
			}

			/** fill dropdown list of stages */
			function fill() {
				for (var i in reports_data.filter_preload.asset_type) {
					var asset = reports_data.filter_preload.asset_type[i];
					ctl.options.push(
						{ text: asset, value: i }
					)
				}
			}

			/** change event */
			function change(value) {
				ctl.args.operator = "equals";
				ctl.args.values[0] = value;
			}
		}
	}
})();