define(['jquery'], function($){
    // PULLS OUT VALUE OF cat_id  FROM URL AND LOADS IT INTO param
	return function () {
        var form = $("form[name='stage_expiry']");

        $('#ta_search').on('click', changeFilterStatus);

    	form.submit(function(ev) {
    		if (typeof form.validate !== 'undefined')
    			form.validate();
    	});

    	// version control
    	$("#view_version_link").click(function(){
    		$(this).find("span").toggle();
    		$("#versions").toggleClass("d-none");
    	});

    	cla_tabs_init($("#tab-container"));

    	$('#reset').on('click', resetSearchForm);

        var param = getParameterByName('cat_id');
        function getParameterByName( name ) {
            name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
            var regexS = "[\\?&]"+name+"=([^&#]*)",
                regex = new RegExp( regexS ),
                results = regex.exec( window.location.href );

            if( results !== null ) {
                return results[1];
            }

            return "";
        }

        $('#submit_cat').on('click', validateCreateCategory);

        // Client side validation when creating a new policy
        $("#submit").click(function(){

            if (!$("#ref_code").val())	// Reference code
            {
                alert(lmsg("policy.error.no_ref"));
                return false;
            }
            if (!$("#title").val()) // A title must be given
            {
                alert(lmsg("policy.error.title_missing"));
                return false;
            }

            if (!$('#component_user_picker_1 option:selected').val()) // Policy owner
            {
                alert(lmsg("policy.error.no_owner"));
                return false;
            }
            if (!$('#component_user_picker_2 option:selected').val()) // Policy author
            {
                alert(lmsg("policy.error.no_author"));
                return false;
            }

            // Display the correct file upload field
            var uploadFile;
            if ($('#upload_file_radio').is(':checked'))
            {
                    uploadFile = $("#source").val();
                    var uploadedFile2 = $("#uploaded_file").text().length;

                    if(!uploadFile && !uploadedFile2)
                    {
                        alert(lmsg("policy.error.no_attachment"));
                        return false;
                    }
            }

            if ($('#upload_document_radio').is(':checked'))
            {
                    uploadFile = parseInt($("#document").val(), 10);
                    if(uploadFile === 0)
                    {
                            alert(lmsg("policy.error.no_attachment"));
                            return false;
                    }
            }
            if ($('#upload_weblink').is(':checked'))
            {
                    uploadFile = $("#weblink_input").val();
                    if(uploadFile === 0)
                    {
                            alert(lmsg("policy.error.no_attachment"));
                            return false;
                    }
            }
            if ($("select[name=\"categories_ids[]\"] option:selected").size() === 0) {
                alert(lmsg("policy.error.no_category"));
                return false;
            }
            if ($("select[name=owners] option").length === 0) { // Check some permissions have been set
                alert(lmsg("policy.error.no_permission"));
                return false;
            }
        });

    	// Close the warning div on cancel
    	$('a#cancel').click(function() {
    		$('#warning, #type_warning').slideUp();
    		return false;
    	});

        // for deleting policy types
        $('a#type_delete').click(function () {
            var has_policies = $(this).data("policies");
            var msg = $(this).data("confirm");
            var id =  $(this).data("id");

            xajax_get_policies_in_type(id);

            if( has_policies )
            {
                $("#type_warning").slideDown();
                $("#type_continue").off().on('click', function () {
                    if(confirm(msg)) {
                        $("#type_actions-"+id).submit();
                    }
                });
                return false;
            } else
            {
                if(confirm(msg)) {
                    $(this).parent().submit();
                }
                return false;
            }
        });

    	// Show/Hide the correct warning message (div)
    	$('a.multiple_cats,a.single_cat,a.is_parent_cat').click(function(e) {
    		$("#continue").attr('href', $(this).attr('href'));
    		// Warning of a category with >= 1 policies associated
    		if ($(this).attr('class') == 'multiple_cats')
    		{
    			$('div#single_cat_warn, div#parent_cat_warn').hide();
    			$('div#has_policies_warn').show();
    			xajax_get_policies($(this).attr('id').split("-")[1]);
    		}
    		// Warn that the selected category has a policy associated to it, and no other
    		else if ($(this).hasClass('single_cat'))
    		{
    			$('div#parent_cat_warn, div#has_policies_warn').hide();
    			$('div#single_cat_warn').show();
    			setTimeout(function() { $('#warning').slideUp(); }, 5000);
    		}
    		// Warn that the category has child categories
    		else if ($(this).hasClass('is_parent_cat'))
    		{
    			$('div#has_policies_warn, div#single_cat_warn').hide();
    			$('div#parent_cat_warn').show();
    			setTimeout(function() { $('#warning').slideUp(); }, 5000);
    			xajax_get_child_cats($(this).attr('id').split("-")[1]);
    		}
    		$('#warning').slideDown();
    		e.preventDefault();

    	});

        // $('#d_filter_form').submit();

        checkAdvancedSearchState();
    };

});

window.changeFilterStatus = function() {
	var signType = $('#ta_search_input').val() == 'minus' ? 'plus' : 'minus';
	toggleSearchButtonIcon(signType);
	$('#ta_search_input').val(signType);
};

// Display the advanced search options if the advanced box was open when the user conducted their search
window.checkAdvancedSearchState = function() {
	var wasAdvancedSearchOpen = $('#ta_search_input').val() === 'minus';

	if (wasAdvancedSearchOpen) {
		// show advanced search options
		$('#manage_filter').addClass('in');

		// Show 'open' state for advanced search button toggle
		toggleSearchButtonIcon('minus');
	}
};

window.toggleSearchButtonIcon = function(type) {
	$('#ta_search_img').removeClass().addClass('glyphicons glyphicons-circle-' + type );
};

// Client side validation when creating a category
window.validateCreateCategory = function() {
	if ( $("#title").val() === 0) {
		alert(lmsg("policy.error.title_missing"));
		return false;
	}

	if ($("select[name=owners] option").length === 0) {
		alert(lmsg("policy.error.no_permission"));
		return false;
	}
};

window.resetSearchForm = function() {
	$('#stage, #type, #attachment_type, #category_drop').val(0);
	$('#keywords, #keywords2, #expiry_date_start, #expiry_date_end, #review_date_start, #review_date_end').val('');
	$("#checkbox_blank_review_date").prop('checked', false);
};
