<?php
$_db_migration_to = '02.06';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_add_policy_content.php', <<<'DB_UPDATE_FILE'
<?php
global $APPDATA;

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();
$db->AddColumn('policy_attachments','details','CLOB');

if (!is_dir("$APPDATA/policy/images"))
{
	mkdir("$APPDATA/policy/images", 0777, true);
}
DB_UPDATE_FILE
);


$migrations->Run('02_add_policy_types.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->CreateTable('policy_types', array(
	'id'	=> 'IDENTITY',
	'title'	=> 'VARCHAR(255) NULL'
));
DB_UPDATE_FILE
);


$migrations->Run('03_add_type_column.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('policies', 'type_id', 'INT NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


$migrations->Run('04_add_related_table.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->CreateTable('policy_relations', array(
	'id'			=> 'IDENTITY',
	'policy_id'		=> 'INT NOT_NULL',
	'related_id'	=> 'INT NOT_NULL'
));
DB_UPDATE_FILE
);


$migrations->Run('05_policy_review_notification_sent.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('policies', 'notified', 'INT NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('02.06');
