<?php
$_db_migration_to = '08.01'; // 2.6.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_dbvar_to_config.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$results = $db->query(
	"SELECT var_name, var_value FROM variables WHERE var_name IN ('policy_ref_pattern', 'policy_items_per_page', 'policy_allow_minor_edits')"
);
//ToDo: Test in MSSQL.
$policy_config = [];
while ($row = $results->fetchArray())
{
	if ($row['var_name'] === 'policy_ref_pattern')
	{
		$policy_config['reference_pattern'] = (string) $row['var_value'];
	} elseif ($row['var_name'] === 'policy_items_per_page')
	{
		$policy_config['items_per_page'] = (int) $row['var_value'];
	} elseif ($row['var_name'] === 'policy_allow_minor_edits')
	{
		$policy_config['allow_minor_edits'] = (bool) $row['var_value'];
	}
}

if (!isset($policy_config['reference_pattern']))
{
	$policy_config['reference_pattern'] = '';
}

if (!isset($policy_config['items_per_page']))
{
	$policy_config['items_per_page'] = 10;
}

if (!isset($policy_config['allow_minor_edits']))
{
	$policy_config['allow_minor_edits'] = false;
}

$json_str = json_encode($policy_config, JSON_PRETTY_PRINT);

$config_directory = $migrations->GetDataDir() . '/config';

if (!is_dir($config_directory))
{
	$migrations->Log("Policy Migration failed; config directory does not exist!");
	throw new Exception("Policy Migration failed; config directory does not exist!");
}

$file_path = $config_directory . '/policy.json';

if (file_put_contents($file_path, $json_str) !== strlen($json_str))
{
	$migrations->Log("Policy Migration failed; error writing config file");
	throw new Exception("Policy Migration failed; error writing config file");
}

chmod($file_path, 0664);

$db->query(
	"DELETE FROM variables WHERE var_name IN ('policy_ref_pattern', 'policy_items_per_page', 'policy_allow_minor_edits', 'policy_link_target')"
);

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('08.01');
