define(['jquery','cla_select2'], function(jQuery)
{
	return function () {
		// Moved from functions.js and expanded to include labels

		var form = jQuery("form[name='stage_expiry']");

		// Admin panel stage details
		form.find("input[type='checkbox']").each(function(i, el) {
			if(!jQuery(this).is(":checked")) {
				jQuery(this).parents("tr").find("input.stage-name").prop('readonly', true);
				jQuery(this).parents("tr").find("input.label-name").prop('readonly', true);
			}
		});

		form.find("input[type='checkbox']").click(function(e) {
			var enabled = jQuery(this).is(":checked") ? true : false;
			jQuery(this).parents("tr").find("input[type='text']").prop('readonly', !enabled);
			if (enabled)
			{
				var name = jQuery(this).parents("tr").find(".js-stage-name").val();
				if (name !== '')
					jQuery(this).parents("tr").find(".js-status-label").show();
				jQuery(this).parents("tr").find(".js-status-label").text(name);
			} else
			{
				jQuery(this).parents("tr").find(".js-status-label").hide();
				jQuery(this).parents("tr").find(".js-status-label").text('');
			}
		});

		jQuery(".js-stage-name").on('keyup', function(e)
		{
			var value = jQuery(this).val();
			jQuery(this).parents('tr').find('.js-status-label').text(value);
			if (value.length > 0)
				jQuery(this).parents("tr").find(".js-status-label").show();
			else
				jQuery(this).parents("tr").find(".js-status-label").hide();
		});

		form.submit(function(ev) {
			if (typeof form.validate !== 'undefined')
				form.validate();
		});
	}

});