define(['jquery'], function(jQuery){

	return function () {
		jQuery("#select2_categories_ids").select2({
			placeholder: "Select categories..."
		});

		if (jQuery("#new_version_selector").is(":visible")) {
			jQuery('input[name*="parent"]').prop('disabled', true);
			jQuery('#stage_id option[value!="1"]').remove();
		}

		jQuery('#references').on('click', '.delete', function() {
			if(confirm('Are you sure you wish to remove this Link?')) {
				jQuery(this).parents('tr').remove();
			}
		});

		jQuery("#remove_document").click(function() {
			jQuery("#document:input").attr("value","");
			jQuery("#document_id:input").attr("value","");
		});
		jQuery("#add_ref").click(function(){
			var id = "new";
			var title = jQuery("#link_title").val();
			var url = jQuery("#url").val().replace(",", "&#44");
			var target = jQuery('input[name=target]').prop('checked');
			var link_new_window;

			if (title.length != 0 && url.length != 0 && url != "http://")
			{
				if (target)
				{
					target = 1;
					link_new_window = '<a class="new_window" target="blank" href="' + url + '" title="' + title + '" ></a>';
				}
				else
				{
					target = 0;
					link_new_window = '';
				}
				var link = '<a class="link" href="' + url + '" title="' + title + '" >' + title + '</a>';
                // temporarily replace any commas in titles or links strings when submitting form
                // leaving commas results in a bug when the parameters were exploded in php using commas as a delimiter.
                var arr = [id, title.replace(/\,/g, '[#comma#]'), url.replace(/\,/g, '[#comma#]'), target];

				if (title && (url != "http://") && url)
				{
					jQuery("#references").append('<tr><td>' + link + '<input id="new" type="hidden" name="refer[]" value="' + arr + '" />' + link_new_window + '</td><td class="text-center"><a href="#" class="delete"><ion-icon name="trash-outline"></ion-icon></a></td></tr>');
					jQuery("#link_title").val("");
					jQuery("#url").val("http://");
					jQuery('input[name=target]').attr('checked', false);
				}
				return false;
			}
			else
			{
				cla.showMessage(lmsg('policy.edit.related_item_link_validation'),'','info');
				return false;
			}
		});
		jQuery("#url").val("http://");

		function getExpiryDate(day_stage)
		{
			if(day_stage)
			{
				var myDate = new Date();

				var newDate = myDate.setDate(myDate.getDate() + parseInt(day_stage));
				var myDate2 = new Date(newDate);
				var day = myDate2.getDate();

				if (isNaN(myDate2.getTime())) {
					// Not a valid date.
					return "";
				}

				if ((day.toString()).length < 2)
				{
					day = "0" + day;
				}
				var month = myDate2.getMonth();
				month++;
				if ((month.toString()).length < 2)
				{
					month = "0" + month;
				}
				var year = myDate2.getFullYear();
				return day + "-" + month + "-" + year;
			}
			return "";
		}

		var stages = [];
		stages[1] = jQuery("#draft_stage-body").val();
		stages[2] = jQuery("#stage_consultation-body").val();
		stages[3] = jQuery("#stage_ratification-body").val();
		stages[4] = jQuery("#stage_distribution-body").val();
		stages[5] = jQuery("#stage_accepted-body").val();

		if (jQuery("#stage_id").val() == 1 && jQuery("#edit_mode").val() == 0)
		{
			var stage = jQuery("#stage_id").val();
			if (stages[stage] !=0)
			{
				jQuery("#expiry_date").val(getExpiryDate(stages[1]));
			}
		}
		jQuery("#stage_id").change(function() {
			var stage = jQuery("#stage_id").val();
			if (stages[stage] != 0)
			{
				if(stage == 6) {
					jQuery("#expiry_date").val("");
				}
				else {
					jQuery("#expiry_date").val(getExpiryDate(stages[stage]));
				}
			}
			else
			{
				jQuery("#expiry_date").val("");
			}
		});

		var curr_attachment_type = jQuery('#curr_attachment_type').val();
		if (curr_attachment_type) {
			changeTabs(curr_attachment_type);
		}
	}
});

window.changeTabs = function(type) {
    jQuery('#documents, #files, #weblink, #page').hide();

    if (type == 'files') {
        jQuery('#upload_file_radio').attr("checked", true);
    }
    else if (type == 'documents') {
        jQuery('#upload_document_radio').attr("checked", true);
    }
    else if (type == 'weblink') {
        jQuery('#upload_weblink').attr("checked", true);
    }
    else if (type == 'page') {
        jQuery('#upload_page').attr("checked", true);
    }
    else {
        return false;
    }

    jQuery('#'+type).show();
    return true;
};

window.editPolicySubmit = function ()
{
    if (jQuery('#prev_recall').val() == 0 && jQuery('#recall').is(':checked')) {
        jQuery('#recall-modal').modal('show');
        return false;
    }
    else if (jQuery('#prev_recall').val() == 1 && !jQuery('#recall').is(':checked')) {
        jQuery('#un-recall-modal').modal('show');
        return false;
    }

    return true;
};
