var internal = CKEDITOR.editorConfig;

/**
 * Wrapper around Claromentis editorConfig
 * @param config
 * @returns {*}
 */
CKEDITOR.editorConfig = function ( config )
{
    // execute Claromentis editorConfig
    internal(config);

    // Prevents CKE4 from removing certain HTML elements and attributes tag(classes)[attributes]{styles}
    config.allowedContent = true;
    config.extraAllowedContent = 'video[*]{*};source[*]{*};map[*]{*};area[*]{*};img[usemap];iframe[*]{*};link[*]{*};script[*]{*};';
    // Allow the "role" attribute on all elements
    config.extraAllowedContent += '*(*)[role]';
    // Allow the "aria-" attribute on all elements
    config.extraAllowedContent += ';*(*)(*)[aria-*]';
    // Allow the "data-" attribute on all elements
    config.extraAllowedContent += ';*(*)(*)[data-*]';

    config.forcePasteAsPlainText = false;
    config.pasteFromWordRemoveFontStyles = false;
    config.pasteFromWordRemoveStyles = false;

    // override toolbar
    config.toolbar_Full =
        [
            { name: 'document',    items : [ 'Source','-','Preview','Print','-','Templates' ] },
            { name: 'clipboard',   items : [ 'Cut','Copy','Paste','PasteText','PasteFromWord','-','Undo','Redo' ] },
            { name: 'editing',     items : [ 'Find','Replace'/*,'-','SpellChecker', 'Scayt'*/ ] },
            { name: 'links',       items : [ 'Link','Unlink','Anchor' ] },
            '/',
            { name: 'basicstyles', items : [ 'Bold','Italic','Underline','Strike','Subscript','Superscript','-','RemoveFormat' ] },
            { name: 'paragraph',   items : [ 'NumberedList','BulletedList','-','Outdent','Indent','-','Blockquote','CreateDiv','-','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'] },
            { name: 'insert',      items : [ 'Image', 'ImageMaps','Flash','Youtube','Video','MediaEmbed','Table','HorizontalRule','Smiley','SpecialChar','PageBreak', 'GoogleMaps' ] },
            '/',
            { name: 'styles',      items : [ 'Styles','Format','Font','clafontsize','TextColor','BGColor' ] },
            { name: 'tools',       items : [ 'Maximize', 'ShowBlocks' ] }
        ];
};
