<?php
$_db_migration_to = '01.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('00_schema.php', <<<'DB_UPDATE_FILE'
<?php

$DROP_TABLES = FALSE;

$db->CreateTable("policy_categories", array(
    "id" => "IDENTITY",
    "title" => "VARCHAR_MAX NULL",
	"parent" => 'INT DEFAULT 0',
	"icon_ext" => "VARCHAR(5)"
), $DROP_TABLES);

$db->CreateTable("policy_attachments", array(
    "id" => "IDENTITY",
    "file_name" => "VARCHAR_MAX NULL",
    "file_path" => "VARCHAR_MAX NULL",
    "doc_id" => "INT NOT_NULL DEFAULT 0",
    "policy_id" => "INT NOT_NULL DEFAULT 0",
    "version" => "INT NOT_NULL DEFAULT 0",
    "type" => "INT NOT_NULL DEFAULT 0",
    "created_date" => "INT_DATE",
    "creator" => "INT NOT_NULL DEFAULT 0",
    "stage_id" => "INT NOT_NULL DEFAULT 0",
), $DROP_TABLES);

$db->CreateTable("policies", array(
    "id" => "IDENTITY",
    "ref_code" => "VARCHAR_MAX NULL",
    "title" => "VARCHAR_MAX NULL",
    "owner" => "INT NOT_NULL DEFAULT 0",
    "creator" => "INT NOT_NULL DEFAULT 0",
	"author" => "INT NOT_NULL DEFAULT 0",
    "changed_by" => "INT NOT_NULL DEFAULT 0",
    "stage_id" => "INT NOT_NULL DEFAULT 0",
    "stage_changed_by" => "INT NOT_NULL DEFAULT 0",
    "stage_changed_time" => "INT_DATE",
    "description" => "VARCHAR_MAX NULL",
    "expiry_date" => "INT_DATE",
	"review_date" => "INT_DATE",
    "attachment_id" => "INT NOT_NULL DEFAULT 0",
    "created_date" => "INT_DATE",
    "perm_error" => "INT NOT_NULL DEFAULT 0",
    "survey" => "INT NOT_NULL DEFAULT 0",
    "recall" => "INT NOT_NULL DEFAULT 0",
    "parent_policy" => "INT NOT_NULL DEFAULT 0"
), $DROP_TABLES);

$db->CreateTable("policy_stage_approves", array(
    "id" => "IDENTITY",
    "stage_id" => "INT NOT_NULL DEFAULT 0",
    "user_id" => "INT NOT_NULL DEFAULT 0",
    "comment_id" => "INT NOT_NULL DEFAULT 0",
    "policy_id" => "INT NOT_NULL DEFAULT 0",
    "approved" => "INT NOT_NULL DEFAULT 0",
    "approved_date" => "INT_DATE",
    "policy_attachments" => "INT NOT_NULL DEFAULT 0",
), $DROP_TABLES);

$db->CreateTable("policy_comments", array(
    "id" => "IDENTITY",
    "comment_text" => "VARCHAR_MAX NULL",
    "user_id" => "INT NOT_NULL DEFAULT 0",
    "stage_id" => "INT NOT_NULL DEFAULT 0",
    "policy_id" => "INT NOT_NULL DEFAULT 0",
    "posted_date" => "INT_DATE",
    "policy_attachments" => "INT NOT_NULL DEFAULT 0",
), $DROP_TABLES);

$db->CreateTable('policy_parents', array(
	'id' => 'IDENTITY',
	'policy_id' => 'INT NOT_NULL DEFAULT 0',
	'parent_id' => 'INT NOT_NULL DEFAULT 0'
), $DROP_TABLES);

$db->CreateTable('policy_references', array(
	'id' => 'IDENTITY',
	'policy_id' => 'INT NOT_NULL DEFAULT 0',
	'title' => 'VARCHAR_MAX NULL',
	'url' => 'VARCHAR_MAX NULL',
	'open_new' => 'INT NOT_NULL DEFAULT 1'
), $DROP_TABLES);



DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.01');
