<?php
$_db_migration_to = '02.18';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_document_version_save.php', <<<'DB_UPDATE_FILE'
<?php

$db = $migrations->GetDb();

$db->AddColumn('policy_attachments', 'doc_version', 'INT NOT_NULL DEFAULT 0');

$db->query('UPDATE policy_attachments SET doc_version = version WHERE type eq:int:doc_type OR type eq:int:deleted_doc_type', PolicyAttachment::TYPE_DOCUMENT, PolicyAttachment::TYPE_DOCUMENT_DELETED);

$res = $db->query('SELECT id, policy_id, version FROM policy_attachments ORDER BY policy_id ASC, id ASC');
$policy_id = 0;
while ($row = $res->fetchArray())
{
	if ($policy_id == $row['policy_id'])
	{
		$version_counter += 1;
	} else
	{
		$policy_id = $row['policy_id'];
		$version_counter = 1;
	}

	if ($version_counter != $row['version'])
	{
		$db->query('UPDATE policy_attachments SET version=int:version WHERE id=int:id', $version_counter, $row['id']);
	}
}
DB_UPDATE_FILE
);


$migrations->Run('02_policies_attachment_repair.php', <<<'DB_UPDATE_FILE'
<?php
$db = $migrations->GetDb();

$res = $db->query('SELECT id FROM policies WHERE attachment_id = 0');

while ($row = $res->fetchArray())
{
	$res2 = $db->query('SELECT MAX(id) id FROM policy_attachments WHERE policy_id eq:int:id', $row['id']);

	while ($inner_row = $res2->fetchArray())
	{
		$db->query('UPDATE policies SET attachment_id=int:att_id WHERE id=int:id', $inner_row['id'], $row['id']);
	}
}
DB_UPDATE_FILE
);


$migrations->Run('03_history_table.php', <<<'DB_UPDATE_FILE'
<?php

$DROP_TABLES = FALSE;

$db->CreateTable("policy_history", array(
	"id" => "IDENTITY",
	"user_id" => "INT NOT_NULL DEFAULT 0",
	"policy_id" => "INT NOT_NULL DEFAULT 0",
	"change_type" => "INT NOT_NULL DEFAULT 0",
	"change_datetime" => "INT_DATE",
	"change_data" => "VARCHAR_MAX NULL",
	"user_ip" => "VARCHAR(20) NULL",
	"user_proxy_ip" => "VARCHAR(20) NULL",
), $DROP_TABLES);

DB_UPDATE_FILE
);


$migrations->Run('04_policy_version.php', <<<'DB_UPDATE_FILE'
<?php

$db = $migrations->GetDb();

$db->AddColumn('policies', 'historic', 'INT NOT_NULL DEFAULT 0');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('02.18');
