/**
 * An integer filter control
 *
 * @author Simon Willan <simon.willan@claromentis.com>
 */
(function () {
	'use strict';

	angular.module(ng_module_name)
		.directive('repStageControl', repStageControl);

	repStageControl.$inject = ['$timeout'];

	function repStageControl($timeout) {
		var directive = {
			bindToController: true,
			controller: controller,
			controllerAs: "filter",
			restrict: 'E',
			scope: {
				args: '='
			},
			templateUrl: '/intranet/policy/html/tmpl/reports/filters/stage.html'
		};

		return directive;
		//////////////////

		function controller($scope, $element) {
			var ctl = this;

			ctl.change = change;

			ctl.lmsg = {
				placeholder: lmsg('policy.reports.filter.stage_placeholder')
			};

			ctl.options = [];

			init();

			function init() {

				fill();

				$timeout(function () {
					$element.find("#stageFilter").val(ctl.args.values[0]).trigger("change");
				}, 0, true);
			}

			/** fill dropdown list of stages */
			function fill() {
				for (var i in reports_data.filter_preload.stage_id) {
					var stage = reports_data.filter_preload.stage_id[i];
					ctl.options.push(
						{ text: stage, value: i }
					)
				}
			}

			/** change event */
			function change(value) {
				ctl.args.operator = "equals";
				ctl.args.values[0] = value;
			}
		}
	}
})();