define(['jquery'], function(jQuery){
	return function () {
		jQuery("#remove_document").click(function() {
			jQuery("#document:input").attr("value","");
			jQuery("#document_id:input").attr("value","");
		});
		jQuery("#url").val("http://");

		var curr_attachment_type = jQuery('#curr_attachment_type').val();
		if (curr_attachment_type) {
			changeTabs(curr_attachment_type);
		}

// Client side validation when creating a new policy
		jQuery("#submit_content").click(function(){

			// Display the correct file upload field
			var uploadFile;
			if (jQuery('#upload_file_radio').is(':checked'))
			{
				uploadFile = jQuery("#source").val();
				var uploadedFile2 = jQuery("#uploaded_file").text().length;

				if(!uploadFile && !uploadedFile2)
				{
					alert('Please select an attachment.');
					return false;
				}
			}

			if (jQuery('#upload_document_radio').is(':checked'))
			{
				uploadFile = parseInt(jQuery("#document").val(), 10);
				if(uploadFile === 0)
				{
					alert('Please select an attachment.');
					return false;
				}
			}
			if (jQuery('#upload_weblink').is(':checked'))
			{
				uploadFile = jQuery("#weblink_input").val();
				if(uploadFile === 0)
				{
					alert('Please select an attachment.');
					return false;
				}
			}
		});
	}

});

window.changeTabs = function(type) {
    jQuery('#documents, #files, #weblink, #page').hide();

    if (type == 'files') {
        jQuery('#upload_file_radio').attr("checked", true);
    }
    else if (type == 'documents') {
        jQuery('#upload_document_radio').attr("checked", true);
    }
    else if (type == 'weblink') {
        jQuery('#upload_weblink').attr("checked", true);
    }
    else if (type == 'page') {
        jQuery('#upload_page').attr("checked", true);
    }
    else {
        return false;
    }

    jQuery('#'+type).show();
    return true;
};
