<?php
$_db_migration_to = '02.05';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_attached_document_version.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();
$result = $db->query("SELECT DISTINCT doc_id FROM policy_attachments WHERE type=int:type_document ", PolicyAttachment::TYPE_DOCUMENT);
$doc_ids = $result->fetchAllValues();
if (!empty($doc_ids))
{
	foreach ($doc_ids as $doc_id)
	{
		$document = ERMSBrowser::I()->GetData(ERMSBrowser::I()->GetIdByDocId($doc_id));
		$doc_version = $document ? $document->version_num : 1;
		$db->query("UPDATE policy_attachments SET version=int:doc_version WHERE doc_id=int:doc_id", $doc_version, $doc_id);
	}

}




DB_UPDATE_FILE
);


$migrations->Run('02_remove_bookshelf_attachments.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// Remove Bookshelf attachments from the database.
$db->query("DELETE FROM policy_attachments WHERE type = 3");

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('02.05');
