<?php
$_db_migration_to = '02.21';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('06_policies_main_id.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();
$db->AddColumn('policies', 'main_id', 'INT NOT_NULL DEFAULT 0');


// grouping associated policies under same id and version them
$db->query('UPDATE policies SET main_id=id, version=1 WHERE parent_policy=0');

if ($db->type() === 'mysql')
{
	$db->query('UPDATE policies p1 LEFT JOIN policies p2 ON p1.parent_policy=p2.id SET p1.main_id=p1.id, p1.version=1 WHERE p2.main_id IS NULL AND p1.main_id=0 AND p1.parent_policy!=0');
} else if ($db->type() === 'mssql')
{
	$db->query('UPDATE p1 SET p1.main_id=p1.id, p1.version=1 FROM policies p1 LEFT JOIN policies p2 ON p1.parent_policy=p2.id WHERE p2.main_id IS NULL AND p1.main_id=0 AND p1.parent_policy!=0');
}

// we are interested only in correcting policies with same parent to prepare for next versioning
// policies can be in this state when creating multiple drafts from same policy.
$res = $db->query('SELECT id, parent_policy, created_date FROM policies WHERE parent_policy != 0 ORDER BY created_date ASC');

$policies = [];
while ($data = $res->fetchArray())
	$policies[$data['parent_policy']][$data['id']] = $data['created_date'];

$insert_data = [];

foreach ($policies as $policy_parent => $policy_list)
{
	if (count($policy_list) > 1)
	{
		asort($policy_list);
		foreach ($policy_list as $policy_id => $policy_creation)
		{
			$insert_data[] = array(
				'id' => $policy_id,
				'parent_policy' => (isset($parent_id) ? $parent_id : $policy_parent)
			);
			$parent_id = $policy_id;
		}
	}
}

foreach ($insert_data as $data)
	$db->query('UPDATE policies SET parent_policy=int:parent_policy WHERE id=int:id', $data['parent_policy'], $data['id']);


// update version of policies
$version = 1;
do
{
	$version = $version + 1;
	if ($db->type() === 'mysql')
	{
		$db->query('UPDATE policies p1 INNER JOIN policies p2 ON p1.parent_policy=p2.id SET p1.main_id=p2.main_id, p1.version=int:version WHERE p1.main_id=0', $version);
	} else if ($db->type() === 'mssql')
	{
		$db->query('UPDATE p1 SET p1.main_id=p2.main_id, p1.version=int:version FROM policies p1 INNER JOIN policies p2 ON p1.parent_policy=p2.id WHERE p1.main_id=0', $version);
	}
}
while ($db->affected() && $version < 50);


// updating and correcting historic status of policies
$db->query('UPDATE policies SET historic=0');
$res = $db->query("SELECT id, main_id, version, stage_id FROM policies");

$policies = $policy_stage = [];
while($data = $res->fetchArray())
{
	$policies[$data['main_id']][$data['id']] = $data['version'];
	$policy_stage[$data['id']] = $data['stage_id'];
}

// stages distribution, accepted, archived
$policy_stages_list = array(4, 5, 6);

foreach($policies as $policy_group => $policy_list)
{
	if (count($policy_list) > 1)
	{
		arsort($policy_list);
		foreach ($policy_list as $policy_id => $policy_version)
		{
			if (isset($previous_stage) && in_array($previous_stage, $policy_stages_list))
			{
				$historic[] = $policy_id;
				continue;
			}
			$previous_stage = $policy_stage[$policy_id];
		}
		unset($previous_stage);
	}
}

if (isset($historic))
{
	$chunks = array_chunk($historic, 500);

	foreach ($chunks as $input_data)
		$db->query('UPDATE policies SET historic=1 WHERE id IN in:int:ids', $input_data);
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('02.21');
