// Vendor lazyframe CSS
require('../../../node_modules/lazyframe/dist/lazyframe.css');
// Custom lazyframe CSS
require('../../css/lazyframe.css');

define(['jquery', '../../../node_modules/lazyframe/dist/lazyframe.min.js'], function ($, lazyframe) {
	return function () {
		$(document).ready(function () {
			initializeLazyFrame();
			showVersionViewMore();
		});

		$('body').on('click', '.js-version-view-more', toggleVersionViewMore);

		function initializeLazyFrame() {
			$('.lazyframe[data-vendor="youtube"]').each(function () {
				var embed = $(this);

				// Load the title and thumbnail for each embed
				$.ajax({
					url: 'https://noembed.com/embed',
					data: {
						url: embed.data('src')
					},
					dataType: 'json',
					success: function (data) {
						embed.attr('data-title', data.title);
						embed.attr('data-thumbnail', data.thumbnail_url);

						// Apply lazyframe
						lazyframe(embed, {
							debounce: 250,
							lazyload: true
						});
					}
				});
			});
		}

		function showVersionViewMore() {
			$('.js-version-details').each(function() {
				if ($(this)[0].scrollHeight >  $(this).innerHeight()) {
					$(this).next().removeClass('d-none');
				}
			});
		}

		function toggleVersionViewMore() {
			$(this).hide().prev().addClass('show-full-details');
			return false;
		}
	}
});

window.hideActiveComments = function(attachment_id) {
	jQuery('#attachment_' + attachment_id).removeClass('version-comments-visible card-body');
	jQuery('#attachment_' + attachment_id).children().hide();
};

window.addActiveComments = function(attachment_id) {
	jQuery('#attachment_' + attachment_id).addClass('version-comments-visible card-body');
};

window.removeAttachment = function(id){
    jQuery('#attachment-id-' + id).remove();
    var versions = jQuery('[id^="attachment-id-"]').length;
    if (versions == 0) {
        jQuery('#view-history-tab').hide();
    }
    else if (versions == 1) {
        // Don't show the delete option if there's only one version (not allowed).
        jQuery('#version_tab .js-remove-version').hide();
    }
};

window.HpHideRejectComment = function() {
    $('#consultation_comment_block').addClass('d-none');
};

window.HpShowRejectComment = function() {
    $('#consultation_comment_block').removeClass('d-none');
};

window.HpShowHideRejectComment = function(show) {
    if (show) HpShowRejectComment(); else HpHideRejectComment();
};

window.HpToggleCommentBox = function(show) {
    $("#add_comment").attr('disabled', !$("#add_comment").attr('disabled'));
};

window.AddStageStatus = function(status) {
    jQuery('#stage_status').val(status);
};
