<?php
// This file contains the database schema version 10.02
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// policies
$table_descr = array(
	'id'	=>	"IDENTITY",
	'ref_code'	=>	"VARCHAR_MAX NULL",
	'title'	=>	"VARCHAR_MAX NULL",
	'owner'	=>	"INT NOT_NULL DEFAULT 0",
	'creator'	=>	"INT NOT_NULL DEFAULT 0",
	'author'	=>	"INT NOT_NULL DEFAULT 0",
	'changed_by'	=>	"INT NOT_NULL DEFAULT 0",
	'stage_id'	=>	"INT NOT_NULL DEFAULT 0",
	'stage_changed_by'	=>	"INT NOT_NULL DEFAULT 0",
	'stage_changed_time'	=>	"INT_DATE NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'expiry_date'	=>	"INT_DATE NULL",
	'review_date'	=>	"INT_DATE NULL",
	'attachment_id'	=>	"INT NOT_NULL DEFAULT 0",
	'created_date'	=>	"INT_DATE NULL",
	'perm_error'	=>	"INT NOT_NULL DEFAULT 0",
	'recall'	=>	"INT NOT_NULL DEFAULT 0",
	'parent_policy'	=>	"INT NOT_NULL DEFAULT 0",
	'last_modified'	=>	"INT_DATE NULL",
	'type_id'	=>	"INT NOT_NULL DEFAULT 0",
	'notified'	=>	"INT NOT_NULL DEFAULT 0",
	'historic'	=>	"INT NOT_NULL DEFAULT 0",
	'version'	=>	"INT NOT_NULL DEFAULT 1",
	'main_id'	=>	"INT NOT_NULL DEFAULT 0",
	'accept_text'	=>	"VARCHAR(255) NULL DEFAULT ''",
);

$db->CreateTable('policies', $table_descr, true);



// policy_attachments
$table_descr = array(
	'id'	=>	"IDENTITY",
	'file_name'	=>	"VARCHAR_MAX NULL",
	'file_path'	=>	"VARCHAR_MAX NULL",
	'doc_id'	=>	"INT NOT_NULL DEFAULT 0",
	'policy_id'	=>	"INT NOT_NULL DEFAULT 0",
	'version'	=>	"INT NOT_NULL DEFAULT 0",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
	'created_date'	=>	"INT_DATE NULL",
	'creator'	=>	"INT NOT_NULL DEFAULT 0",
	'stage_id'	=>	"INT NOT_NULL DEFAULT 0",
	'details'	=>	"CLOB NULL",
	'doc_version'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('policy_attachments', $table_descr, true);



// policy_categories
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR_MAX NULL",
	'parent'	=>	"INT NULL DEFAULT 0",
	'icon_ext'	=>	"VARCHAR(5) NULL",
);

$db->CreateTable('policy_categories', $table_descr, true);



// policy_comments
$table_descr = array(
	'id'	=>	"IDENTITY",
	'comment_text'	=>	"VARCHAR_MAX NULL",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'stage_id'	=>	"INT NOT_NULL DEFAULT 0",
	'policy_id'	=>	"INT NOT_NULL DEFAULT 0",
	'posted_date'	=>	"INT_DATE NULL",
	'policy_attachments'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('policy_comments', $table_descr, true);



// policy_history
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'policy_id'	=>	"INT NOT_NULL DEFAULT 0",
	'change_type'	=>	"INT NOT_NULL DEFAULT 0",
	'change_datetime'	=>	"INT_DATE NULL",
	'change_data'	=>	"VARCHAR_MAX NULL",
	'user_ip'	=>	"VARCHAR(50) NULL",
	'user_proxy_ip'	=>	"VARCHAR(50) NULL",
);

$db->CreateTable('policy_history', $table_descr, true);



// policy_parents
$table_descr = array(
	'id'	=>	"IDENTITY",
	'policy_id'	=>	"INT NOT_NULL DEFAULT 0",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('policy_parents', $table_descr, true);



// policy_references
$table_descr = array(
	'id'	=>	"IDENTITY",
	'policy_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR_MAX NULL",
	'url'	=>	"VARCHAR_MAX NULL",
	'open_new'	=>	"INT NOT_NULL DEFAULT 1",
);

$db->CreateTable('policy_references', $table_descr, true);



// policy_relations
$table_descr = array(
	'id'	=>	"IDENTITY",
	'policy_id'	=>	"INT NOT_NULL",
	'related_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('policy_relations', $table_descr, true);



// policy_stage_approves
$table_descr = array(
	'id'	=>	"IDENTITY",
	'stage_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'comment_id'	=>	"INT NOT_NULL DEFAULT 0",
	'policy_id'	=>	"INT NOT_NULL DEFAULT 0",
	'approved'	=>	"INT NOT_NULL DEFAULT 0",
	'approved_date'	=>	"INT_DATE NULL",
	'policy_attachments'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('policy_stage_approves', $table_descr, true);



// policy_types
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('policy_types', $table_descr, true);





//===========================================================================================
$migrations->SetVersion('10.02');
