# Policy Manager Change Log

## Unreleased

### Improvements

- !112 POM-92 Added the policy type to the policy PDF download

## 4.0.7 - 5th December 2025

### Improvements

- !111 POM-90 AI Policy now responds in the user’s selected language, or defaults to the system language if none is set
- !111 POM-90 Add localization support for text "Ask questions about this policy"

## 4.0.6 - 29th October 2025

- !102 FRAM-1070 Updated component library usages for policy cover images for improved accessibility

## 4.0.5 - 21st August 2025

### Developer notes

- Merged upstream changes from 3.0.26

## 4.0.4 - 8th August 2025

- !109 BT-5413 Added French, German, Portuguese (Brazil), Spanish, and Dutch translations for AI features

## 4.0.3 - 28th July 2025

### Developer notes

- Merged upstream changes from 3.0.25

## 4.0.2 - 15th July 2025

### Improvements

- !106 POM-76 Improved performance when loading policy documents for AI generative chat

## 4.0.1 - 4th July 2025

### Developer notes

- !105 POM-74 Moved AI Assistant styles to Core

## 4.0.0 - 9th June 2025

### Improvements

- !104 FRAM-1076 Fine-tuned the responses of the AI Policy Chat

## 4.0.0-beta2 - 7th May 2025

### Improvements

- !101 POM-70 Improved relevance of content generated by multi-modal generative AI

### Bug fixes

- 333f6b5f Fixed a system warning that could occur if Policy AI hadn't yet been enabled or disabled

## 4.0.0-beta - 16th April 2025

### New features

- !93 POM-70 Added AI Assistant support for the Policy view

### Bug fixes

- 3a8a74b9 BT-5189 Fixed a PHP 8 incompatibility error that could occur when creating Policies
- 08f266ce FRAM-1053 Fixed PHP 8 incompatibilities reported by PHPCS

### Developer notes

- Merged upstream changes from 3.0.23
- !93 POM-70 Added AI Policy Plugin for Multi-modal Generative AI for Policies

## 4.0.0-alpha2 - 28th November 2024

- Merged upstream changes from 3.0

## 4.0.0-alpha - 14th November 2024

- FRAM-954 Claromentis 10 compatibility

## 3.0.26 - 21st August 2025

### Improvements

- !110 POM-83 Added support for viewing Policy PDFs using PDF.js on mobile devices

## 3.0.25 - 24th July 2025

### Bug fixes

- !107 BT-5354 Fixed Policy details warning message icon alignment issue
- !108 BT-5355 Fixed Policy details archived versions badges alignment

## 3.0.24 - 5th June 2025

### Bug fixes

- !103 BT-5345 Fixed policy badges spacing on mobile/tablet screen resolutions


## 3.0.23 - 1st April 2025

### Bug fixes
- !100 BT-5222 Fixed an issue where the default "All Policies" view was not shown when navigating using breadcrumbs


## 3.0.22 - 6th March 2025

### Bug fixes

- !99 BT-5150 Fixed issue where related items would not open in a new window despite being set to do so
- !99 BT-5150 Fixed minor layout issue where the delete icon for newly added related items was not centred

## 3.0.21 - 13th February 2025

### Bug fixes

- !98 BT-5130 Added missing localisations

## 3.0.20 - 16th December 2024

### Bug fixes

- !97 BT-5010 Fixed an issue with old cached content in PDF files

## 3.0.19 - 5th December 2024

### Bug fixes

- !96 BT-5061 Fixed a regression where the defined acceptance text for a policy was not shown

## 3.0.18 - 26th November 2024

### Bug fixes

- !94 BT-3887 Fixed PDF design layout issues in Policy
- !92 BT-4859 Disco 046766 Fixed an issue where the Policies List table rows were not sorting correctly.
- !92 BT-4945 Fixed an issue where the "Last Modified" column was not sorting correctly.

## 3.0.17 - 28th August 2024

### Bug fixes

- !91 BT-4833 Disco 046596 Fixed an issue where an error can occur when viewing policies in list view.

## 3.0.16 - 12th July 2024

- Merged upstream changes from  2.6.26

## 3.0.15 - 19th June 2024

### Improvements

- !90 BT-4696 French localisation update
- !84 POM-65 Improved Awaiting Action component (included description, version, attachment, removed expiry date)
  - Improved the design and layout for Policy details
- !89 BT-4684 German localisation update

## 3.0.14 - 23rd May 2024

### Improvements

- !88 POM-68 When viewing a policy which has a PDF also show the PDF title

## 3.0.13 - 6th February 2024

- Merged upstream changes from 2.6

## 3.0.12 - 19th January 2024

### Improvements

- !81 UIUX-862 Improved semantic heading title in Policy details

### Bug fixes

- !83 BT-4336 Disco 043491 Hide Add Policy button based on permissions to edit Policy Category

## 3.0.11 - 22nd November 2023

- Merged upstream changes from 2.6

## 3.0.10 - 21st September 2023

### Bug fixes

- !77 BT-4278 Fixed a tooltip localization phrase that caused an error when customized

## 3.0.9 - 18th September 2023

### Merged forward from 2.6

### Bug fixes

- !76 BT-4248 DISCO 42845 Enabled field "Tags" in Policy Manager when the user has no permission to create a new tag

## 3.0.8 - 16th June 2023

* Declared compatibility with Claromentis Core 10

## 3.0.7 - 16th June 2023

* Merged upstream changes from 2.6

## 3.0.6 - 3rd May 2023

* Merged upstream changes from 2.6.21

## 3.0.5 - 20th March 2023

### Improvements

* Merged upstream changes from 2.6.19 

## 3.0.4 - 28th February 2023

### Improvements

* Merged upstream changes from 2.6
* !73 POM-46 Added policy version and creation date for archived versions on the Policy page
* !71 POM-42 Added a new configuration option for choosing landing page
* !72 POM-43 Added notifications to the policy owner and author after every relevant user accepted/approved the policy stage

## 3.0.3 - 13th December 2022

### Improvements

* Merged upstream changes from 2.6
* !67 BOOTY-582 Replaced utility classes usages with Bootstrap 4 standard utility classes
* FRAM-838 Added application menu item registration

### Bug fixes
* 5488ea06 BT-3491 Fixed issue with text not breaking correctly on Policy edit and single page causing it to overflow off the page.
* 26579575 BOOTY-400 Fixed some minor styling issues on policy
  * BT-3490 Fixed issue with link button overflowing the wrapper on smaller screen devices
  * BT-3491 Fixed issue with Policy cards icons overflowing the card on smaller displays and generally squashed design on tablets
  * 4f713ab1 f2de00b7 BT-3523 BT-3604 Fixed alignment issue in Policy Manager when 'My Policies' section gets squashed up and causes overflow issues on Mobile. 
* !66 BT-3447 Fixed system error when downloading policy as PDF
* 710f9595 BT-3653 Minor fix to text wrapping of policy titles on Policy component
* cf9531c8 BOOTY-617 Replaced `hidden` CSS class usages with `d-none`

## 3.0.2 - 17th August 2022

### Merged forward from 2.6

### Bug fixes
* !65 BT-3498 Disco 38284 Disco 38405 Fixed bug with HTML entity `&hellip;` at the end of title due to the text double escaping

## 3.0.1 - 5th August 2022

### Improvements

* BOOTY-400 Fixed some minor styling issues on policy homepage
 * BT-3474 Fixed issue where there was no margin between Policies and search field 
 * BT-3475 Fixed issue where pagination buttons were being cut off
* 14176941 BOOTY-500 BOOTY-505 Updated policy pages component IDs so it uses the new class structure
* 407bd548 BOOTY-502 Updated Policy card background colour for reports module
* 8876e78 BT-3461 Fixed minor issue with layout of related items form and table on policy add/edit page

### Bug fixes

* BT-3453 Fixed upload image via CKEditor on page Edit Policy Content

## 3.0.0 - 30th June 2022

### Improvements

* FRAM-657 Updated Reports Schema icon from Glyphicon to SVG
* FRAM-471 Declared support for PHP 8.1

### Bug fixes

* d4016a46 BOOTY-400 Further minor fixes to the design of single policy pages and comments
* 0f8204bc BOOTY-400 Fixed slew of design issues in Policy including comment design, css file refinement and BT-3432 fixes to status fields on smaller viewports
* 3e3b9278 BT-3377 Fixed unescaped Policy titles as well as a number of small usability and readability fixes to the ckeditor.js file
* 38d87a1a BOOTY-400 Number of bug fixes and design improvements to policy
  * BT-3421 Fixed issue where advanced forms were overflowing the viewport on smaller displays
  * BT-3422 Fixed issue with alignment of 'Export to CSV' on Admin and Policy reports pages on small screen devices.
* !63 BT-3426 Removed Survey legacy code from module
* 88d7a1b6 BT-3442 Fixed filesystem errors for Policy attachments when creating or editing Policies

### Merged forward from 2.6

#### Improvements

* !60 BT-3296 Removed redundant Mandatory policies listing from top of the manage policies page. Mandatory, and other policies needing attention, are still listed separately on the main policies page.
* !61 FRAM-800 wkhtmltopdf 0.12.6 compatibility

#### Bug fixes

* 06863551 BT-2804 Fixed undefined index error when editing policy permissions
* !62 BT-3377 Fixed unescaped Policy titles when editing Policies

## 3.0.0-beta - 28th February 2022

### New features
- Claromentis 9 compatibility

### Improvements
* !57 FRAM-427 Replaced JS & CSS asset loader with Webpack 

### Bug fixes
* 9ecd615d BOOTY-400 Fixed design compatibility issues
  * BOOTY-496 Fixed issue with design of auto-generated PDF file
  * BOOTY-497 Very minor fixes to icon selection and alignment on Policy details page 
  * BOOTY-498 Replaced Glyphicons with Ionicons in Acceptance history
* !57 BOOTY-400 Claromentis 9 fixes after QA
  * Changed Icon implementation to use the Icon component and Ionicons

## 2.6.26 - 12th July 2024

### Bug fixes

- !87 POM-62 Fixed incorrect results for the Policy Manager Pages component when using the "All my policies" and "All policies" filters

## 2.6.25 - 6th February 2024

### Bug fixes

- !86 BT-4245 Disco 042830 Disco 043221 Fixed Bootstrap accordion links not working in Policy content (CKEditor)

### Developer notes

- !86 BT-4245 Disco 042830 Disco 043221 Enabled support for `aria-*`, `role`, and `data-*` attributes in CKEditor to ensure proper functioning of the accordion feature.

## 2.6.24 - 22nd November 2023

### Bug fixes

- !80 BT-4214 Fixed spacing issue under PDF image in Policy Manager

## 2.6.23 - 18th September 2023

### Bug fixes

- !76 BT-4248 DISCO 42845 Enabled field "Tags" in Policy Manager when the user has no permission to create a new tag

## 2.6.22 - 16th June 2023

### Bug fixes

- !75 BT-3761 Removed the option to add public permissions for policies

## 2.6.21 - 2nd May 2023

### Bug fixes

- fe021928 aa370742 RD-41 Fixed further issues with policy content processing for PDF generation

## 2.6.20 - 17th April 2023

### Bug fixes

- e1927629 RD-41 Fixed an issue with HTML processing for policy content prior to PDF generation

## 2.6.19 - 20th March 2023

### Improvements

* !74 POM-58 Added a new option to the Policy Manager configuration for hiding the `Download as PDF` button

## 2.6.18 - 24th February 2023

### Bug fixes

* !70 BT-3732 Disco 038904 Prevented invalid dates in Policies from causing front-end errors

## 2.6.17 - 20th October 2022

### Improvements
* !69 POM-45 Added status, version and description to PDF version of policy 

## 2.6.16 - 4th October 2022

### Bug fixes
* !68 BT-3589 Fixed upload image via CKEditor on page Edit Policy Content

## 2.6.15 - 16th August 2022

### Bug fixes
* !65 BT-3498 Disco 38284 Disco 38405 Fixed bug with HTML entity `&hellip;` at the end of title due to the text double escaping

## 2.6.14 - 30th June 2022

### Bug fixes
* !62 BT-3377 Fixed unescaped Policy titles when editing Policies

## 2.6.13 - 20th June 2022

### Bug fixes
* 06863551 BT-2804 Fixed undefined index error when editing policy permissions

### Improvements
* !61 FRAM-800 wkhtmltopdf 0.12.6 compatibility

### Developer notes
* !61 RD-31 Fixed SSRF vulnerability

## 2.6.12 - 5th April 2022

### Improvements

* !60 BT-3296 Removed redundant Mandatory policies listing from top of the manage policies page. Mandatory, and other policies needing attention, are still listed separately on the main policies page.

## 2.6.11 - 28th February 2022

* !59 BT-3163 Removing CKEditor SpellChecker feature to avoid crash

## 2.6.10 - 20th January 2022

* BT-3007 Fixed permissions issue where users with 'edit content' rights could not see policies in draft stage
* POM-44 Renamed 'edit' and 'edit content' permission localisations to make it clearer what they allow

## 2.6.9 - 30th July 2021

### Bug fixes
* !56 BT-2644 disco33418 Reverted attempted fix made in 2.6.7 to prevent errors being embedded in documents

## 2.6.8 - 26th March 2021

### Bug fixes
* !55 BT-2237 Approval and acceptance lists now show data again

## 2.6.7 - 22nd March 2021

### Improvements

* !52 POM-41 Policy reference codes can now be up to 25 characters

### Bug fixes

* !53 BT-2204, disco30188 - Prevent errors being embedded in downloaded policy documents.

## 2.6.6 - 22nd February 2021

* !54 BT-2215 Fixed "Download as PDF" button not working on Claromentis 8.9

## 2.6.5 - 9th November 2020

### Features merged forward from 2.5.9

* !24 CORE-1063 The acceptance text for a policy (eg "I have read & understood") can now be set per-policy

## 2.6.4 - 3rd November 2020

### Bug fixes

* !51 BT-2023 Fixed PHP error on policy view page when running under PHP 7.4

## 2.6.3 - 12th October 2020

### Bug fixes merged forward from 2.4.9, 2.5.8
* !50 BT-1105 Fixed approving a policy without leaving a comment causing an error growl

## 2.6.2 - 2nd October 2020

* !49 UIUX-644 Added "download as PDF" link for policies with a "page" document

## 2.6.1 - 13th August 2020

* Deleted leftover scripts that caused exceptions when viewing policies

## 2.6.0 - 05th August 2020

### Improvements

* !29 PMSW-9 Policy navigation menu is now available when viewing a Policy directly.
* !30 PMSW-14 Replaced Settings page with more generic Configuration page.
* !44 PMSW-28 Filtering by Category will generate breadcrumbs.
* !34 PMSW-8 Policy navigation menu indicates sub-categories.

### Bug fixes

* !33 BT-1796 PMSW-20 Fixed missing localizations in Admin.
* !28 PHP Warning will no longer display when submitting a new Policy from the Permissions tab, without selecting a Category.
* !38 Policies awaiting confirmation will be hidden when filtering by Tag on the My Policies view.
* !38 PMSW-34 Filtered Tag will no longer be reset when changing page in Tile View.
* !41 PMSW-35 Filtered Tag will no longer be reset when using Keyword Search.
* !47 PMSW-36 Filtered Tag will no longer be reset when changing between Tile and List Views.

### Breaking changes

* `\Policy`:
  * `GetCategoriesArray`:
    * Added parameter types.
    * Added return type.
  * `GetCategory`: Added return type.
  * `GetArchivedVersions`: Removed.
* `\PolicyType::GetAllTypes`:
  * Added parameter types.
  * Added return type.
* `\PolicyViewOne`:
  * `ShowBriefIndex`:
    * Updated parameters.
    * Added return type.
  * `ShowDetails`:
    * Added parameters.
    * Added return type.
  * `ShowView`: Added parameters.
* `\PolicyViewTiles`:
  * `USE_SIZE`: Removed.
  * `IMAGES_PATH`: Removed.
  * `__construct`: Added parameters.
  * `GetUrlParams`: Removed.
  * `SetUrlParams`: Removed.
  * `GetQuerystring`: Removed.
  * `SetQuerystring`: Removed.
  * `GetPolicies`: Removed.
  * `SetPolicies`: Removed.
  * `GetRelated`: Removed.
  * `SetRelated`: Removed.
  * `GetCategories`: Removed.
  * `SetCategories`: Removed.
  * `Render`:
    * Updated parameters.
    * Added return type.
* `\Claromentis\Policy\Controller\MainPageController`
  * `__construct`: Added constructor parameters.
  * `Show`:
    * Updated parameters.
    * Added return type.
* `\Claromentis\Policy\Controller\MyPoliciesController`:
  * `__construct`: Added parameters.
  * `Show`:
    * Updated parameters.
    * Added return type.
* `\Claromentis\Policy\Controller\PolicyInfoController::ShowPolicy`: Removed.
* `\Claromentis\Policy\Search\View\PolicyView`: Added constructor parameters.
* `\PolicyPlugin::BASE_URL`: Removed.
* `view_policy.php`: Removed.
* `admin_policy_details.php`: Removed.
* `\Policy`:
  * `GetItemsPerPage`: Removed.
  * `GetPolicyTargetLink`: Removed.
  * `GetNewestVersion`: Removed.
  * `GetActualVersion`: Removed.
* `\PolicyController::__construct`: Added constructor parameters.
* `\Claromentis\Policy\view\CategoriesNavigation`:
  * `__construct`: Added constructor parameters.
  * `Show`:
    * Updated parameters.
    * Added return type.
* `\Claromentis\Policy\PolicyListProviderInterface`:
  * Added method `GetTagName`.
  * Added method `SetTagName`.
* `\Claromentis\Policy\PolicyListProvider`:
  * `GetTag`:
     * Renamed to `GetTagName`.
     * Added return type.
  * `SetTag`:
     * Renamed to `SetTagName`.
     * Added parameter type.
     * Added return type.
* `\Claromentis\Policy\MyPoliciesListProvider`:
  * `SetTag`:
     * Renamed to `SetTagName`.
     * Added parameter type.
     * Added return type.
* `\PolicyViewTileController`:
  * `__construct`: Updated parameters.
  * `RenderView`: Updated parameters.
  * `CreateUrlParams`: Added parameter.
* `\PolicyRelation::GetMenu`: Removed.

### Developer notes

* `\PolicyType::GetList`: deprecated.
* Calls to '/intranet/policy/view_policy.php' should be handled by `\Claromentis\Policy\Controller\RedirectController::Redirect` and be redirected to `\Claromentis\Policy\Controller\PolicyController::View`.
* Calls to '/intranet/policy/admin_policy_details.php' should be handled by `\Claromentis\Policy\Controller\RedirectController::Redirect` and be redirected to `\Claromentis\Policy\Controller\AdminController::Configuration`.
* !30 Migrated Configurations constants from repository to config file.
* !30 PMSW-14 Added `phpunit.xml`.
* !38 PMSW-23 Converted `\PolicyViewTileController` to a service.
* !38 PMSW-23 Converted `\PolicyViewTiles` to a service.

## 2.5.9 - 9th November 2020

### Features
* !24 CORE-1063 The acceptance text for a policy (eg "I have read & understood") can now be set per-policy

## 2.5.8 - 12th October 2020

### Bug fixes merged forward from 2.4.9
* !50 BT-1105 Fixed approving a policy without leaving a comment causing an error growl

## 2.5.7 - 4th August 2020

### Improvements
* !26 UIUX-674 Policy manager's error messages are friendlier

### Developer Notes
* Merged forward fixes from 2.4.8

## 2.5.6 - 3rd July 2020

### Developer notes

* Merged forward fixes from 2.4.7

## 2.5.5 - 18th June 2020

### Bug fixes

* !27 BT-1764 Fixed error on attachment download page.

## 2.5.4 - 3rd April 2020
### Bug fixes
* !23 CORE-1065 When a policy has a PDF attachement, a preview of that PDF is displayed on the view policy page

## 2.5.3 - 6th March 2020
### Developer Notes
* Merged `2.4.6`

## 2.5.2 - 17th February 2020
### Developer Notes
* Merged `2.4.5`

## 2.5.1 - 4th February 2020
### Developer Notes
* Merged `2.4.4`

## 2.5.0 - 27th January 2020
* Claromentis 8.9 compatibility (Elasticsearch 7)
* Core dependency updated to **>=8.9**

## 2.4.9 - 12th October 2020
## Bug fixes
* !50 BT-1105 Fixed approving a policy without leaving a comment causing an error growl

## 2.4.8 - 3rd August 2020

### Improvement
* !45 BT-1872 Creating a new version of a Policy will now remove the previous version from the Search Index.

## 2.4.7 - 3rd July 2020
* !31 BT-1802 A negative number or non-numeric value can no longer be given for the "policies per page" admin area setting
* !28 CORE-1066 the items in the category menu on the main page are now sorted alphabetically

## 2.4.6 - 6th March 2020
* !25 BT-1099 Updated all policies keyword search to only return results containing all keywords instead of any keyword.

## 2.4.5 - 17th February 2020
### Bug fixes
* !22 BT-1064 When new policy creation fails, the contents of the rich text editor is preserved

## 2.4.4 - 4th February 2020

### Bug Fixes
* !21 BT-1099 Updated Policy Keyword Searching to be conjunctive rather than disjunctive.

## 2.4.3 - 27th January 2020

* Marked as incompatible with Claromentis 8.9 (Elasticsearch changes)

### Improvements

* !20 BT-919 Creating a new version of a policy will now pre-populate the details of the previous version

## 2.4.2 - 27th November 2019
* CORE-1036 Added Hungarian translation

## 2.4.1
* Added Uzbek translation

## 2.4.0
* Core dependency updated **>=8.6**
### Improvements
* !18 CORE-973 Added Component `Policy Manager` to Category `Documents & Policies`.
* !18 CORE-974 Added Localized Titles to the `Policy Manager` Component.

## 2.3.6 - 27th January 2020
* !19 (BT-557) Viewing old versions of a policy will redirect to the new version unless `archive=true` is used on the URL

## 2.3.5
### Improvements
* UIUX-558 Tidied Policy Manager icons for iPad resolution.

## 2.3.4
* Added Russian translations and twig templates

## 2.3.3
* Fixed CKEditor image upload (CKFinder) compatibility for Claromentis 8.2+
* Fixed PHP 7.2 incompatibilities

## 2.3.2
* Fix Approved and Acceptance reports status counts and user list (CORE-440)

## 2.3.1
* Fixed PHP error when removing a review date (Jira CORE-139)

## 2.3.0
* Changed Pages policy component to include "all my policies" and "all policies" options

## 2.2.10
* Fix image error when creating a new version (#702)
* Fix image height display issue when cropping an image

## 2.2.9
* Composer.json compatibility with future versions of core.

## 2.2.8
* Made it so that searching within a category or type works as expected

## 2.1.9
* Allowed user acceptance report for archived policies (Disco 19373)

## 2.2.7
* Resolution to policies not showing accepted users when archived. (Disco #019373)
* Fix some policies appearing twice. (Disco #019825)
* Fixed bug to show acceptances of archived policies. (Disco 19373)
* Allowed user acceptance report for archived policies (Disco 19373)

## 2.2.6
* Fixed incorrect URLs in Policy pagination Disco (#019717)

## 2.2.5
* Added some German traslations (Disco #017837)

## 2.2.4
* Added some missing localisation
* Marked as compatible with Claromentis 8.3

## 2.2.3
* Added some missing localisation
* Merged all bugfixes from 2.1.x

## 2.2.2
* Implemented lazy-loaded YouTube embeds for Policy Asset History to
  drastically improve performance in this situation

## 2.2.1
* Merged fixes from 2.1.6

## 2.2.0
* Made keywords-based search in the user end much faster (using ElasticSearch)
* Removed search by policy content on "Manage Policies" page

## 2.2.0-rc2
* Fixed some subcategories not being displayed in the admin area (#555)
* Fixed responsive design for homepage component for IE10/IE11 (#541)
* Fixed responsive design for permissions when creating/editing a policy (#554)
* Re-added tags cloud to the main page, limited to 40 tags
* Design improvements for action buttons in Policy admin list and other tables
  (mod/pages#420)

## 2.2.0-rc
* Compatibility with Claromentis 8.2

## 2.1.8
* Fix some policies appearing twice (disco 19825)

## 2.1.7
* Acceptance report fix (disco 18402)

## 2.1.6
* Mandatory policy bugfix (disco 18216)

## 2.1.5
* Added missing German translations (disco 17837)

## 2.1.4
* Re-added tags cloud to the main page, limited to 40 tags
* Fixed component responsiveness in IE
* Prevented some admin panel warnings when generating a report

## 2.1.3
* Various bugs fixed
* Added missing German translation phrases

## 2.1.2
* Fixed templater error when accepting a policy (Disco 016996)

## 2.1.1
* Fixed error when exporting policies to CSV
* Made "awaiting actions" component looking better

## 2.1.0
* Minor bugfixes before release

## 2.1.0-rc2
* Compatibility fixes for PHP7
* Fixed MSSQL compatibility issues and bugs
* Implemented sending a notification to approvers when policy content changes (#525)
* Updated the Reports integration to support version 1.2.0
* Merged forward from 2.0.8
  * German translation fixes (DISCO 015646)
  * General localization improvements
* Ensured notifications are sent when editing policy content alone (#525)
* Added red background and warning glyphicon to mandatory reads, removed tag cloud and
  added height to policy card title (#528)

## 2.1.0-rc
* Added ability to make minor edits to policies in distribution
* Added "Don't send notification" option for use when bulk-creating policies
* Split acceptance (of asset) and approval (of policy) and treat them separately
* Improvements to target users list, including ability to filter by asset version

## 2.1.0-beta
* Compatibility with Claromentis 8.1
* Pages component for "policies awaiting action"

## 2.0.12
* Prevented some admin panel warnings when generating a report

## 2.0.11
* Minor corrections to German translation

## 2.0.10
* Fix policy acceptance when survey is active

## 2.0.9
* Fix incorrect localization key 
* Fix policy refs title comma bug (disco 16441)
* Fix character limit in policy card (#527)

## 2.0.8
* German translation fixes  (disco 015646)

## 2.0.7
* Recalling a policy would try to send 2 notifications per user, with only one of those being effected by the the "notify users" checkbox.  
  (DISCO 015646, #524)

## 2.0.6
* Ensured that only the latest version of a policy shows in the user reports
  (DISCO 013315)

## 2.0.5
* Fixed mismatching "contents" field type in ElasticSearch index
  NOTE: reindexing is required

## 2.0.4
* Removed acceptance form from archived policies
* Visual improvements
* Added admin panel icon
* Added sorting policies by title
* Hidden category images as they are not displayed
* Removed historic policies from global search
* Prevented notifcaion about archived policies
* Fixed indexing policies permissions

## 2.0.3
* Added German translation
* Reformatted spaces on ViewPolicyOne and view_policy
* Increased AP address field lengths to fit IPv6
* Fixed issues
  * 233, 444, 446, 447
* Prevented old versions of policies being indexed by elasticsearch when updated (Disco 14115).
* Other minor bugfixes

## 2.0.2
* Fixed possible error in old migration script when run in Claromentis 8
* Fixed erroneous target users link for users with edit content permissions (#440)

## 2.0.1
* Reverted awaiting policies from div layout to table
* Fixed critical bug whereby saving policies as recalled gave an error if attachment type was file.
* Fixed critical bug whereby review_date was an integer being compared against a DateDay

## 2.0.0
* Compatibility with Claromentis 8.0
* Fixed issues
  * 137, 154, 191, 
  * 227, 251, 263, 
  * 331, 340, 359, 387, 
  * 406, 407, 408, 411, 413, 414, 415
* Optimised approvers list so it only runs the SQL once rather than three times
* Removed several columns from different table views to save on space
* Minor textual changes
* Minor design changes
* Minor glyphicon changes

## 1.10.6
* Added Acceptance History tab on policy details page
* Prevent archived policies from being selected as related
* Fixed displaying page 2 and more in policies list
* Added tooltip for full category name in the left column if it's truncated
* Fixed displaying HTML/BB special chars in search results
* Fixed stage expiration notification if it's less than 15 days

## 1.10.5
* Bugfix to show items correctly when no items-per-page had been set.
* Bugfix for child categories being shown at all levels, not just when viewing their parent.  

## 1.10.4
* Set search indexing to only find non historic, and distribution only policies
* Optimised page load times where approvers list is not necessary (but was previously being loaded an unused)
* Further optimizations

## 1.10.3
* New linear versioning of policies
* Bug fixes

## 1.10.2
* Fixed bug with moving file from Documents
* New versions can have same name and ref_code as previous versions
* If version is in progress state, previous version points to it

## 1.10.1
* Bug fixes
* Deny creating multiple other versions from one version
* Documents are now attached as files

## 1.10.0
* New version system for all types of attachments
* Changed version system of policies
* New content edit permission
* History of policy changes

## 1.9.4
* Fixed server error when attachment is missing
* Corrected hint text for stage approval

## 1.9.3
* Repaired critical bug in awaiting action component
* Few bugs repaired

## 1.9.2
* Repaired bug in awaiting action component

## 1.9.1
* Repaired bugs in users report

## 1.9.0
* Added report for policies users
* Added component which displays policies waiting for user
* Changed admin page layout

## 2.0.0 (not released yet)
* Compatibility with Claromentis 8

## 1.8.0
* TODO: populate this

## 1.7.0
* Requires Claromentis 7.4
* Support for integrated intranet search

## 1.6.5
* Supports installation via composer

## 1.6.0
* Requires Claromentis 7.3
