<?php
namespace Claromentis\Projects;

$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"] = (@$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"] ?: array()) + array();
use Claromentis\Core\Security\SecurityContext;
use Claromentis\People\Entity\User;
use Claromentis\People\Service\UserExtranetService;







class PermissionsChecker
{
    
    
    protected SecurityContext $security_context;
    
    
    protected PermissionsMap $permissions_map;
    
    
    protected UserExtranetService $extranets;
    public function __construct(PermissionsMap $permissions_map, SecurityContext $_73b2c7f63beda4fd56c50913117f0ae6, UserExtranetService $extranets)
    {
        $this->permissions_map = $permissions_map;
        $this->security_context = $_73b2c7f63beda4fd56c50913117f0ae6;
        $this->extranets = $extranets;
    }
    
    
    
    
    
    
    
    
    
    public function CanI($project_id, $_6436cc3b9318272858bde36ace15b33b, $task_id = 0) : bool
    {
        
        
        if ($project_id !== null) {
            return $this->permissions_map->PermitsProjectAction($this->security_context, $project_id, $_6436cc3b9318272858bde36ace15b33b);
        }
        
        
        return $this->permissions_map->PermitsTaskAction($this->security_context, $task_id, $_6436cc3b9318272858bde36ace15b33b);
    }
    public function GetObjectIDsWithRight(int $user_id, int $_6436cc3b9318272858bde36ace15b33b)
    {
        return $this->permissions_map->GetObjectIDsWithRight($user_id, $_6436cc3b9318272858bde36ace15b33b);
    }
    public function GetCurrentUserId()
    {
        return $this->security_context->GetUserId();
    }
    public function DoIHaveFullAccess()
    {
        return $this->permissions_map->PermitsFullAccess($this->security_context);
    }
    public function CanICreateProjects()
    {
        return $this->permissions_map->PermitsCreateProjects($this->security_context);
    }
    public function CanIViewPublicTasks(int $project_id)
    {
        return $this->CanI($project_id, Permissions::VIEW_TASKS) || $this->CanI($project_id, Permissions::VIEW_ALL_TASKS);
    }
    public function CanIEditCompanies()
    {
        return $this->permissions_map->PermitsEditCompanies($this->security_context);
    }
    public function GetProjectTeamMembers(int $project_id, bool $_1149477a48af14215d07056a2657dc1d = true) : array
    {
        return $this->permissions_map->GetProjectTeamMembers($project_id, $_1149477a48af14215d07056a2657dc1d);
    }
    public function GetProjectMembersWithReceiveRights(int $project_id, bool $_1149477a48af14215d07056a2657dc1d = true) : array
    {
        return $this->permissions_map->GetProjectMembersWithReceiveRights($project_id, $_1149477a48af14215d07056a2657dc1d);
    }
    public function GetProjectMembersWithExtendedNotificationRights(int $project_id, bool $_1149477a48af14215d07056a2657dc1d = true) : array
    {
        return $this->permissions_map->GetProjectMembersWithExtendedNotificationRights($project_id, $_1149477a48af14215d07056a2657dc1d);
    }
    public function GetProjectMembersWithViewAllTasksRights(int $project_id, bool $_1149477a48af14215d07056a2657dc1d = true) : array
    {
        return $this->permissions_map->GetProjectMembersWithViewAllTasksRights($project_id, $_1149477a48af14215d07056a2657dc1d);
    }
    
    
    
    
    
    
    
    
    public function CanViewUser(User $_24e0e36600d6af77406a44bb618a6253) : bool
    {
        $_9aa1db89206e80c571adeb0f95f475a9 = $this->security_context->GetExtranetAreaId();
        $_a50b89f7a699cedab7cc721b2e6008e5 = (int) $this->extranets->GetPrimaryId();
        $_efe8c242f08cb71f5880d41c4b0277f8 = $_24e0e36600d6af77406a44bb618a6253->extranet_id === $_9aa1db89206e80c571adeb0f95f475a9;
        
        
        $_937cadb17c002f24c2c0a404cf5211f8 = $_24e0e36600d6af77406a44bb618a6253->extranet_id === $_a50b89f7a699cedab7cc721b2e6008e5;
        
        
        $_461ff8e483fcc49be3040c8bf249e0e4 = $_9aa1db89206e80c571adeb0f95f475a9 === $_a50b89f7a699cedab7cc721b2e6008e5;
        return $_efe8c242f08cb71f5880d41c4b0277f8 || $_461ff8e483fcc49be3040c8bf249e0e4 || $_937cadb17c002f24c2c0a404cf5211f8;
    }
}