define(['./add_task.component.html'], function (template)
{
    var AddTask = {
        bindings: {},
        templateUrl: template,
        controller: [
            '$timeout',
            '$scope',
            'projectPreloadFactory',
            function ($timeout, $scope, projectPreload) {
                var ctrl = this;

                ctrl.isVisible= false;
                angular.element(document).on('projectsTabChange', function($event, tabName) {
                    ctrl.isVisible = tabName === 'tasks';

                    $timeout(function() {
                        $scope.$digest();
                    }, 0);
                });

                ctrl.$onInit = function() {
                    ctrl.project_id = projectPreload.id;
                    ctrl.projectDurationUnits = projectPreload.duration_units;
                    ctrl.lists = projectPreload.lists;
                    ctrl.perms = projectPreload.perms;
                };

                ctrl.canAddTask = function() {
                    return ctrl.isVisible && ctrl.perms.can_add_task;
                };

                ctrl.addNewTask = function (data) {
                    angular.element('#headerButtonsApp').trigger('onAddTask', {
                        name: data.name,
                        description: data.description,
                        assignees: data.assignees,
                        due_date: data.due_date,
                        priority: data.priority,
                        duration: data.duration,
                        is_private: data.is_private,
                        list_id: data.list_id,
                        success: data.onSuccess
                    });
                };
            }
        ]
    };

    return AddTask;
});
