define(['./add_task_or_list.html'], function (template)
{
    var AddTaskOrList = {
        bindings: {},
        templateUrl: template,
        controller: [
            '$timeout',
            '$scope',
            'projectPreloadFactory',
            function ($timeout, $scope, projectPreload) {
                var ctrl = this;

                ctrl.isVisible= false;
                angular.element(document).on('projectsTabChange', function($event, tabName) {
                    ctrl.isVisible = tabName === 'tasks';

                    $timeout(function() {
                        $scope.$digest();
                    }, 0);
                });

                ctrl.$onInit = function() {
                    ctrl.perms = projectPreload.perms;
                };

                ctrl.canAddTask = function() {
                    return ctrl.isVisible && ctrl.perms.can_add_task;
                };

                ctrl.canAddList = function() {
                    return ctrl.isVisible && ctrl.perms.can_edit_any_task;
                };
            }
        ]
    };

    return AddTaskOrList;
});
