(function()
{
	var moduleName = 'companyEditApp';

	angular.module(moduleName)
		.controller("companyEditCtrl", ['$scope', 'breadcrumb.service', companyEditController]);

	function companyEditController($scope, breadcrumbService)
	{
		var ctrl = this;

		ctrl.company = company;

		var breadcrumb =
		[
			{
				'url': '/projects/companies',
				'name': lmsg('projects.companies.breadcrumb.companies')
			}
		];

		if (ctrl.company.id > 0)
		{
			breadcrumb.push(
			{
				'url': '/projects/company/' + ctrl.company.id,
				'name': ctrl.company.name
			});
			breadcrumb.push(
			{
				'url': '',
				'name': lmsg('projects.companies.breadcrumb.edit_company')
			});
		} else
		{
			breadcrumb.push(
			{
				'url': '',
				'name': lmsg('projects.companies.breadcrumb.add_company')
			});
		}
		breadcrumbService.setCrumbs(breadcrumb);

		ctrl.delete = function($event)
		{
			$event.preventDefault();
			SendByPost($event.target, confirm(lmsg('projects.js.are_you_sure')));
		}
	}
}());