(function()
{
    var moduleName = 'claromentis.project';
    var template = require('../../html/directives/history_list.directive.html');

    angular.module(moduleName)
        .directive('historyList', historyList);

    historyList.$inject = ['claProjectsHistoryService'];
    function historyList(service)
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                list: '<',
                listStr: '<'
            },
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            ctrl.getListName = function()
            {
                var name = service.getListName(parseInt(ctrl.list));

                if (name !== null)
                    return name;
                else
                    return ctrl.listStr;
            }
        }
    }
}());
