var task_template = require('../../html/directives/taskEditButton.directive.html');

(function()
{
	var moduleName = 'claromentis.project';
	var module;

	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

    module
        .directive('projectTaskEditButton', projectTaskItem);

    projectTaskItem.$inject = ['task_edit_service'];
    function projectTaskItem(service) {
        return {
            restrict: 'E',
            templateUrl: function(elem,attrs) {
                return attrs.templateUrl || task_template
            },
            scope: {
                task: '='
            },
            controllerAs: 'btn',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;
            ctrl.$element = null;

            ctrl.clicked = function(event)
            {
                event.preventDefault();

                service.startEdit(ctrl.task, ctrl.$element);
            };
        }
    }
}());
