(function()
{
    var moduleName = 'claromentis.project';
    var template = require('../../html/directives/history_is_private.directive.html');

    angular.module(moduleName)
        .directive('historyIsPrivate', historyPrivate);

    function historyPrivate()
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                private: '='
            },
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            ctrl.getTaskPrivateName = function()
            {
                if (ctrl.private)
                    return lmsg('projects.history.type.private');

                return lmsg('projects.history.type.not_private');
            }
        }
    }
}());
