define([], function ()
{
    var template = '<clang-users-list-popup></clang-users-list-popup>';

    var UserListService = function($rootScope, $rootElement, $compile, $timeout) {
        var service = this;

        service.users = [];

        service.showUsersList = function(users) {
            service.users = users;

            var modal = $rootElement.find('.js-users_list_modal');
            if (modal.length === 0)
            {
                // Add the template to the end of this applications root element
                var newScope = $rootScope.$new(true);
                $rootElement.append($compile(template)(newScope));
            }

            $timeout(function() {
                $rootScope.$digest();

                modal = $rootElement.find('.js-users_list_modal');
                modal.trigger('update', [service.users]);
                modal.modal('show');
            }, 0);
        };
    };
    UserListService.$inject = ['$rootScope', '$rootElement', '$compile', '$timeout'];

    return UserListService;
});
