var angular = require('cla_angular');
window.angular = angular;

require('./projects.libs.js');
require('ng.cla.core.breadcrumb');
require('ng.cla.core.html_editor');
require('ng.cla.core.lmsg');
require('comments');
require('user_picker');
require('ng.cla.core.lmsg');
require('directive/datePicker.js');

require('./projects.tasks_util');

// Other modules
require('./ng/modules/widgets/projects_widgets.module.js');

angular.module('cla.projects_history', [])
require('./service/history.service.js');

angular.module('taskDetailApp', ['ngResource', 'ui.bootstrap', 'angularUtils.directives.dirPagination', 'claromentis.project', 'commentsModule', 'cla.core.html_editor', 'cla.core.lmsg', 'cla.core.breadcrumb', 'cla.projects_history', 'claromentis.projects.widgets', 'claromentis.project.tasks_util']);

require('./controller/taskCommentsCtrl.js');
require('./controller/taskDetailCtrl.js');
require('./controller/taskFilesCtrl.js');
require('./controller/historyCtrl.js');
require('./model/projectTaskModel.js');
require('./directive/history_changes.directive.js');
require('./directive/history_is_private.directive.js');

require('./directive/history_priority.directive.js');
require('./directive/history_user.directive.js');
require('./directive/history_status.directive.js');
require('./directive/history_list.directive.js');

require('./task/taskEdit.directive.js');
require('./task/taskEditButton.directive.js');
require('./task/taskEdit.service.js');

angular.module('taskDetailApp')
	.filter("sanitize", ['$sce', sanitizeFilter]);

function sanitizeFilter($sce)
{
	return function(htmlCode){
		return $sce.trustAsHtml(htmlCode);
	};
}
