<?php
namespace Claromentis\Projects;

$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"] = (@$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"] ?: array()) + array("_d59e8b45d9de0cf0" . "3727e5e9fd8d37c7" => base64_decode("aGFzX3JpZ2h0cw" . "=="), "_d1071a032215f0eb5c4a8ef175" . "f7049d" => base64_decode("cm9" . "sZQ" . "=="), "_cfc7ad357eb2a4278" . "7a63179d50bbb53" => base64_decode("cmVzcG9uc2liaWxpd" . "Hk="), "_4d707fab93bebb00bbe69" . "e8159697c90" => base64_decode(""), "us" . "er" . "_i" . "d" => base64_decode("dXNlcl9pZ" . "A=="), "_cc68d6d68b25a61fd7" . "70c5c3e8450ccf" => base64_decode("cHJvamVjdHMuYWRtaW4ucGVybXMuY3" . "JlYXRlX25ld19wcm9qZWN0"), "_50efd92" . "c99598ae" . "28570d31" . "983db5d9" . "b" => base64_decode("cHJvamVjdHMuYWRtaW4ucGVybXMuZWR" . "pdF9jb21wYW5pZXM="), "_0c5123aa" . "744f69bbc" . "0e8b3ea2f" . "6e847d" => base64_decode("bG1zZ" . "w=="), "_23ab4dd81b6c619f" . "47099ef7c2485a12" => base64_decode("cm9" . "sZX" . "M="), "_a18f3f2e515f9b" . "634cee4e5fbdcdb" . "572" => base64_decode("cGV" . "ybX" . "M="), "projec" . "t_id" => base64_decode("cHJvamVjdF" . "9pZA=="), "_83028dfc60732657dc3ac25ded36d9" . "32" => base64_decode("cHJvamVjdHMuYWRtaW4ucGVybXMuZnVsbF9wZXJtaXNza" . "W9u"), "_49c6565477ee9" . "f822b499a53e6d" . "2995f" => base64_decode("YXJyYX" . "lfa2V5" . "X2V4aX" . "N0cw=="), "_01f117db67aa749d3ec8da7eb" . "478730c" => base64_decode("L" . "C" . "A" . "="), "_5159b3572969eca46acd1b" . "2e1418459c" => base64_decode("aW1wbG9kZ" . "Q=="), "_8dabb06efc95df4cff7c4afe91857b5" . "3" => base64_decode("bmFt" . "ZQ=="), "_0ea4e32b57963ac0cb3057e03e9a" . "ef64" => base64_decode("a" . "W" . "Q" . "="), "_a48eb1db4f6ab2" . "c82fb9db687c5f4" . "a32" => base64_decode("cmln" . "aHRz"), "_bd71c3b5c201fc11db82ed14ce424d" . "e5" => base64_decode("aW5fY" . "XJyYX" . "k="));
use Claromentis\Core\Acl\Acl;
use Claromentis\Core\Acl\RoleBased\RoleAclChecker;
use Claromentis\Core\Acl\RoleBased\RoleRepository;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Projects\Acl\Rights;
use Claromentis\Projects\Model\Member;
use Claromentis\Projects\Model\Task;
use Claromentis\Projects\Repository\TaskRepository;
use Claromentis\Projects\Repository\TeamRepository;






class PermissionsMap
{
    const PERM_PROJECT_CREATE = 1;
    const PERM_PROJECT_FULL = 2;
    const PERM_EDIT_COMPANIES = 4;
    
    
    const CREATE_PROJECT = 23;
    const EDIT_COMPANIES = 24;
    
    
    const EDIT_ADHOC_TASK = 24;
    const VIEW_ADHOC_TASK = 25;
    const UPDATE_ADHOC_TASK = 26;
    
    
    protected $team_repository;
    
    
    protected $task_repository;
    
    
    protected $admin_acl;
    
    
    protected $role_acl;
    
    
    protected $role_repository;
    public function __construct(TeamRepository $team_repository, TaskRepository $task_repository, Acl $_8b4fbf19a40cd35b5144ef4d8ee73220, RoleAclChecker $_ce30a1539f2fa7dff639ac636142d216, RoleRepository $_90f6cb30a269a622b4c838bfd5a0a5db)
    {
        $this->team_repository = $team_repository;
        $this->task_repository = $task_repository;
        $this->admin_acl = $_8b4fbf19a40cd35b5144ef4d8ee73220;
        $this->role_acl = $_ce30a1539f2fa7dff639ac636142d216;
        $this->role_repository = $_90f6cb30a269a622b4c838bfd5a0a5db;
    }
    public function GetAdminPermsDialogArray()
    {
        return array(self::PERM_PROJECT_CREATE => array($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_0c5123a" . "a744f69b" . "bc0e8b3e" . "a2f6e847" . "d"]($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_cc68d6d68b25a61fd77" . "0c5c3e8450ccf"]), 1), self::PERM_PROJECT_FULL => array($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_0c5123aa744f" . "69bbc0e8b3ea2" . "f6e847d"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_83028dfc6" . "0732657dc3" . "ac25ded36d" . "932"]), 1), self::PERM_EDIT_COMPANIES => array($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_0c5123aa744f69bbc0e8b3ea" . "2f6e847d"]($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_50efd92c99598ae28570d3198" . "3db5d9b"]), 1));
    }
    
    
    
    
    
    
    
    public function PermitsProjectAction(SecurityContext $context, $project_id, $_18f48e103c59a05cbe75b66b44ec5728) : bool
    {
        
        
        if ($_18f48e103c59a05cbe75b66b44ec5728 === self::CREATE_PROJECT) {
            $_3d408935c467487f7ef90c6ba73977ee = false;
            if ($this->admin_acl->Permits($context, self::PERM_PROJECT_CREATE) || $this->admin_acl->Permits($context, self::PERM_PROJECT_FULL)) {
                $_3d408935c467487f7ef90c6ba73977ee = true;
            }
            return $_3d408935c467487f7ef90c6ba73977ee;
        }
        if ($_18f48e103c59a05cbe75b66b44ec5728 === self::EDIT_COMPANIES) {
            $_3d408935c467487f7ef90c6ba73977ee = false;
            if ($this->admin_acl->Permits($context, self::PERM_EDIT_COMPANIES) || $this->admin_acl->Permits($context, self::PERM_PROJECT_FULL)) {
                $_3d408935c467487f7ef90c6ba73977ee = true;
            }
            return $_3d408935c467487f7ef90c6ba73977ee;
        }
        
        
        if ($this->admin_acl->Permits($context, self::PERM_PROJECT_FULL)) {
            return true;
        }
        return $this->role_acl->DoesUserHaveRight(Permissions::PROJECT_AGGREGATION, $project_id, $context->GetUserId(), $_18f48e103c59a05cbe75b66b44ec5728);
    }
    
    
    
    
    
    
    
    public function PermitsTaskAction(SecurityContext $context, $task_id, $_1ac701da0834eb6c188cf3ef004a1aca) : bool
    {
        
        
        if ($this->admin_acl->Permits($context, self::PERM_PROJECT_FULL)) {
            return true;
        }
        $_696b535739055ed7d827709916d07dea = $this->task_repository->LoadTask($task_id);
        $user_id = $context->GetUserId();
        
        
        $_3d408935c467487f7ef90c6ba73977ee = false;
        switch ($_1ac701da0834eb6c188cf3ef004a1aca) {
            case self::VIEW_ADHOC_TASK:
            case self::UPDATE_ADHOC_TASK:
            case Permissions::VIEW_DISCUSSION:
            case Permissions::PARTICIPATE_IN_DISCUSSION:
                if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_bd71c3b" . "5c201fc1" . "1db82ed1" . "4ce424de" . "5"]($user_id, $_696b535739055ed7d827709916d07dea->GetAssignees()) || $user_id == $_696b535739055ed7d827709916d07dea->GetCreatorId()) {
                    $_3d408935c467487f7ef90c6ba73977ee = true;
                }
                break;
            case self::EDIT_ADHOC_TASK:
                if ($user_id == $_696b535739055ed7d827709916d07dea->GetCreatorId()) {
                    $_3d408935c467487f7ef90c6ba73977ee = true;
                }
                break;
        }
        return $_3d408935c467487f7ef90c6ba73977ee;
    }
    public function GetObjectIDsWithRight(int $user_id, int $_18f48e103c59a05cbe75b66b44ec5728)
    {
        return $this->role_acl->GetObjectsForUserWithRight(Permissions::PROJECT_AGGREGATION, $user_id, $_18f48e103c59a05cbe75b66b44ec5728);
    }
    public function PermitsFullAccess(SecurityContext $context)
    {
        $_1f24efd4735b7a11b391147435e7d35d = false;
        if ($this->admin_acl->Permits($context, self::PERM_PROJECT_FULL)) {
            $_1f24efd4735b7a11b391147435e7d35d = true;
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    public function PermitsCreateProjects(SecurityContext $context)
    {
        $_1f24efd4735b7a11b391147435e7d35d = false;
        if ($this->admin_acl->Permits($context, self::PERM_PROJECT_CREATE) || $this->PermitsFullAccess($context)) {
            $_1f24efd4735b7a11b391147435e7d35d = true;
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    public function PermitsEditCompanies(SecurityContext $context)
    {
        $_1f24efd4735b7a11b391147435e7d35d = false;
        if ($this->admin_acl->Permits($context, self::PERM_EDIT_COMPANIES) || $this->PermitsFullAccess($context)) {
            $_1f24efd4735b7a11b391147435e7d35d = true;
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    
    
    public function GetMemberRolesWithRight(int $project_id, int $_18f48e103c59a05cbe75b66b44ec5728) : array
    {
        $_23ab4dd81b6c619f47099ef7c2485a12 = $this->role_repository->GetRolesPopulated(Permissions::PROJECT_AGGREGATION, $project_id);
        $_5db2a45af9531d045f7bd144e7974f0d = [];
        $_aac32009fb9ef1cb19bac01bd59aa3f5 = [];
        
        
        foreach ($_23ab4dd81b6c619f47099ef7c2485a12 as $_d1071a032215f0eb5c4a8ef175f7049d) {
            $_02752cdc22229457e909d01fb90d3a62 = new Acl(RoleRepository::PERM_CLASS_ACL_ROLE, (int) $_d1071a032215f0eb5c4a8ef175f7049d[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_0ea4e32b57963ac0cb305" . "7e03e9aef64"]]);
            $_02752cdc22229457e909d01fb90d3a62->Hydrate(Rights::PermsToLegacyRights($_d1071a032215f0eb5c4a8ef175f7049d[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_a18f3f2e515f9b634cee4e5fbdcdb57" . "2"]]));
            $_5db2a45af9531d045f7bd144e7974f0d[(int) $_d1071a032215f0eb5c4a8ef175f7049d[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_0ea4e32b57963ac" . "0cb3057e03e9aef6" . "4"]]] = $_d1071a032215f0eb5c4a8ef175f7049d[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_8dabb06efc95df4cff7c4afe9" . "1857b53"]];
            $_5bf33f1a68fc4f0fb8f93f3864c005e9 = $_02752cdc22229457e909d01fb90d3a62->GetRightsUserIds(PERM_VIEW, null, false);
            foreach ($_5bf33f1a68fc4f0fb8f93f3864c005e9 as $_24e0e36600d6af77406a44bb618a6253) {
                if (!$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_49c6565477ee9f822b499a" . "53e6d2995f"]($_24e0e36600d6af77406a44bb618a6253, $_aac32009fb9ef1cb19bac01bd59aa3f5)) {
                    $_aac32009fb9ef1cb19bac01bd59aa3f5[$_24e0e36600d6af77406a44bb618a6253] = [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_23ab4dd81b6c619f47099ef7c2" . "485a12"] => [], $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_d59e8b45d9de0cf" . "03727e5e9fd8d37c" . "7"] => false];
                }
                
                
                if (($_d1071a032215f0eb5c4a8ef175f7049d[$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_a48eb1db4f6ab2c82fb9db" . "687c5f4a32"]] & $_18f48e103c59a05cbe75b66b44ec5728) === $_18f48e103c59a05cbe75b66b44ec5728) {
                    $_aac32009fb9ef1cb19bac01bd59aa3f5[$_24e0e36600d6af77406a44bb618a6253][$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_d59e8b45d9de0cf03727e" . "5e9fd8d37c7"]] = true;
                }
                $_aac32009fb9ef1cb19bac01bd59aa3f5[$_24e0e36600d6af77406a44bb618a6253][$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_23ab4dd81b6c6" . "19f47099ef7c24" . "85a12"]][(int) $_d1071a032215f0eb5c4a8ef175f7049d[$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_0ea4e32b57963ac0cb" . "3057e03e9aef64"]]] = $_d1071a032215f0eb5c4a8ef175f7049d[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_8dabb06efc95df4cff" . "7c4afe91857b53"]];
            }
        }
        
        
        $_c5b999916a4d4e96765cfb39eaa3918c = [];
        foreach ($_aac32009fb9ef1cb19bac01bd59aa3f5 as $user_id => $_0c631db04b533c5644eb7fbaafc14b19) {
            if ($_0c631db04b533c5644eb7fbaafc14b19[$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_d59e8b45d9de0cf03727e5e9fd" . "8d37c7"]]) {
                unset($_0c631db04b533c5644eb7fbaafc14b19[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_d59e8b45d9de0cf03727e5e9f" . "d8d37c7"]]);
                $_c5b999916a4d4e96765cfb39eaa3918c[$user_id] = $_0c631db04b533c5644eb7fbaafc14b19;
            }
        }
        return $_c5b999916a4d4e96765cfb39eaa3918c;
    }
    
    
    
    
    
    
    
    
    
    public function GetProjectTeamMembers($project_id, $_1be2ab9e3ab3bcb39f8b8b32778beaf9 = true)
    {
        return $this->GetProjectMembersWithRight($project_id, $_1be2ab9e3ab3bcb39f8b8b32778beaf9, Permissions::TEAM_MEMBER);
    }
    
    
    
    
    
    
    
    
    
    public function GetProjectMembersWithReceiveRights($project_id, $_1be2ab9e3ab3bcb39f8b8b32778beaf9 = true)
    {
        return $this->GetProjectMembersWithRight($project_id, $_1be2ab9e3ab3bcb39f8b8b32778beaf9, Permissions::TEAM_NOTIFICATIONS);
    }
    
    
    
    
    
    
    
    
    public function GetProjectMembersWithExtendedNotificationRights($project_id, $_1be2ab9e3ab3bcb39f8b8b32778beaf9 = true)
    {
        return $this->GetProjectMembersWithRight($project_id, $_1be2ab9e3ab3bcb39f8b8b32778beaf9, Permissions::EXTENDED_NOTIFICATIONS);
    }
    
    
    
    
    
    
    
    
    public function GetProjectMembersWithViewAllTasksRights($project_id, $_1be2ab9e3ab3bcb39f8b8b32778beaf9 = true)
    {
        return $this->GetProjectMembersWithRight($project_id, $_1be2ab9e3ab3bcb39f8b8b32778beaf9, Permissions::VIEW_ALL_TASKS);
    }
    
    
    
    
    
    
    
    
    
    
    protected function GetProjectMembersWithRight($project_id, $_1be2ab9e3ab3bcb39f8b8b32778beaf9 = true, $_18f48e103c59a05cbe75b66b44ec5728 = Permissions::TEAM_MEMBER)
    {
        $_8a659815ed3f1e08e16380582ab21e8f = $this->team_repository->GetKnownTeamMembers($project_id);
        $_aac32009fb9ef1cb19bac01bd59aa3f5 = $this->GetMemberRolesWithRight($project_id, $_18f48e103c59a05cbe75b66b44ec5728);
        $_e4543e131c67c631b14751cc849d1310 = [];
        
        
        foreach ($_aac32009fb9ef1cb19bac01bd59aa3f5 as $user_id => $_0c631db04b533c5644eb7fbaafc14b19) {
            if ($_1be2ab9e3ab3bcb39f8b8b32778beaf9) {
                if ($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_49c656547" . "7ee9f822b4" . "99a53e6d29" . "95f"]($user_id, $_8a659815ed3f1e08e16380582ab21e8f)) {
                    $_a71dc9333bd8ad95d55d6624b477875f = $_8a659815ed3f1e08e16380582ab21e8f[$user_id];
                } else {
                    $_a71dc9333bd8ad95d55d6624b477875f = [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["project_" . "id"] => $project_id, $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["us" . "er" . "_i" . "d"] => $user_id, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_cfc7ad357eb2a42787" . "a63179d50bbb53"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_4d707fab" . "93bebb00b" . "be69e8159" . "697c90"]];
                }
                $_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_d1071a032215" . "f0eb5c4a8ef17" . "5f7049d"]] = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_5159b3572969" . "eca46acd1b2e1" . "418459c"]($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_01f117db67aa749d3ec8da7eb478730" . "c"], $_0c631db04b533c5644eb7fbaafc14b19[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_23ab4dd81b6c619f4" . "7099ef7c2485a12"]]);
                $_a35dab1038a75763ebdb4c72b9c7d59a = new Member();
                $_a35dab1038a75763ebdb4c72b9c7d59a->LoadInfo($_a71dc9333bd8ad95d55d6624b477875f);
            } else {
                $_a35dab1038a75763ebdb4c72b9c7d59a = $user_id;
            }
            $_e4543e131c67c631b14751cc849d1310[] = $_a35dab1038a75763ebdb4c72b9c7d59a;
        }
        return $_e4543e131c67c631b14751cc849d1310;
    }
    
    
    
    
    public function CanViewTask(SecurityContext $context, Task $_696b535739055ed7d827709916d07dea) : bool
    {
        $project_id = $_696b535739055ed7d827709916d07dea->GetProject();
        
        
        if ($this->PermitsProjectAction($context, $project_id, Permissions::VIEW_ALL_TASKS)) {
            return true;
        }
        
        
        if (!$this->PermitsProjectAction($context, $project_id, Permissions::VIEW_TASKS)) {
            return false;
        }
        if ($_696b535739055ed7d827709916d07dea->GetPrivate()) {
            
            
            return $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_bd71c3b5c201fc11d" . "b82ed14ce424de5"]($context->GetUserId(), $_696b535739055ed7d827709916d07dea->GetAssignees());
        }
        
        
        return true;
    }
    
    
    
    
    public function GetTaskOwnerAggregation() : int
    {
        return Permissions::PROJECT_AGGREGATION;
    }
    public function GetRolesWithAcl(int $project_id, int $_18f48e103c59a05cbe75b66b44ec5728) : array
    {
        $_23ab4dd81b6c619f47099ef7c2485a12 = $this->role_repository->GetRolesPopulated(Permissions::PROJECT_AGGREGATION, $project_id);
        $_756cf0b93e827668ee7c9980c715439c = [];
        foreach ($_23ab4dd81b6c619f47099ef7c2485a12 as $_d1071a032215f0eb5c4a8ef175f7049d) {
            if (($_d1071a032215f0eb5c4a8ef175f7049d[$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_a48eb1db4f6ab2c82fb9db687c5f4" . "a32"]] & $_18f48e103c59a05cbe75b66b44ec5728) === $_18f48e103c59a05cbe75b66b44ec5728) {
                $_756cf0b93e827668ee7c9980c715439c[] = $_d1071a032215f0eb5c4a8ef175f7049d;
            }
        }
        return $_756cf0b93e827668ee7c9980c715439c;
    }
}