define(function() { return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/intranet/projects/js/built/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 26);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./html/directives/task.directive.html":
/***/ (function(module, exports) {

var path = '/html/directives/task.directive.html';
var html = "<!--- START View Task -->\n<div ng-if=\"item.display !== 'board'\">\n\t<div class=\"task-item list-task\">\n\t\t<div as-sortable-item-handle=\"\">\n\t\t\t<!-- start bootstrap grid -->\n\t\t\t<div class=\"list-draggable-area\" ng-attr-data-no-drag=\"{{item.noDrag()}}\">\n\t\t\t\t<div class=\"media\">\n\t\t\t\t\t<div class=\"mr-1\">\n\t\t\t\t\t\t<clang-checkbox name=\"checkbox_{{item.task.id}}\" large=\"1\" ng-model=\"item.task.is_complete\" ng-change=\"item.completeToggled($event)\" ng-show=\"item.task.perms.can_update\"></clang-checkbox>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"media-body\">\n\t\t\t\t\t\t<div class=\"row\">\n\t\t\t\t\t\t\t<div class=\"col-12\">\n\t\t\t\t\t\t\t\t<div class=\"media\">\n\t\t\t\t\t\t\t\t\t<div class=\"media-body\">\n\t\t\t\t\t\t\t\t\t\t<span ng-class=\"{'task-item-complete': item.task.is_complete}\">\n\t\t\t\t\t\t\t\t\t\t\t<a ng-if=\"item.task.title !== item.task.title_truncated\" ng-href=\"/projects/task/{{item.task.id}}\" rel=\"tooltip\" data-original-title=\"{{item.task.title}}\">{{item.task.title_truncated}}</a>\n\t\t\t\t\t\t\t\t\t\t\t<a ng-if=\"item.task.title === item.task.title_truncated\" ng-href=\"/projects/task/{{item.task.id}}\">{{item.task.title}}</a>\n\t\t\t\t\t\t\t\t\t\t\t<a ng-href=\"{{item.task.source.link}}\" ng-show=\"(item.showSource) && (item.task.source) && (item.task.source.name !== '')\"><span class=\"text-muted\">({{item.task.source.name}})</span></a>\n\t\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t</div>\n\n\t\t\t\t\t\t\t\t\t<div class=\"ml-2\">\n\t\t\t\t\t\t\t\t\t\t<!--- edit -->\n\t\t\t\t\t\t\t\t\t\t<span ng-if=\"item.showEdit\" >\n\t\t\t\t\t\t\t\t\t\t\t<button class=\"js-task_edit_button_{{item.task.id}} btn btn-link btn-sm\" rel=\"tooltip\" lmsg=\"title:common.edit\" name=\"projects:task:edit\" ng-click=\"item.startTaskEdit($event, item.task.id)\" ng-if=\"item.task.perms.can_edit\">\n\t\t\t\t\t\t\t\t\t\t\t\t<ion-icon name=\"create-outline\"></ion-icon>\n\t\t\t\t\t\t\t\t\t\t\t</button>\n\t\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\n\n\t\t\t\t\t\t<div class=\"row\">\n\t\t\t\t\t\t\t<div class=\"col-12 align-self-center\">\n\t\t\t\t\t\t\t\t<!--- due date -->\n\t\t\t\t\t\t\t\t<span ng-if=\"item.showDate\">\n\t\t\t\t\t\t\t\t\t<span class=\"py-1 pl-0 pr-2 pl-0 mr-2 float-left align-middle\" ng-if=\"item.task.due_date_formatted != ''\">\n\t\t\t\t\t\t\t\t\t\t<span ng-class=\"{'text-danger': item.task.due_date_type=='overdue', 'text-info': item.task.due_date_type=='today'}\">\n\t\t\t\t\t\t\t\t\t\t\t<ion-icon class=\"task-item-icon task-item-icon-gray\" name=\"calendar-outline\"></ion-icon>\n\t\t\t\t\t\t\t\t\t\t\t<span class=\"align-middle small\" ng-if=\"item.task.due_date_type!='today' && item.task.due_date_type!='tomorrow'\">{{item.task.due_date_formatted}}</span>\n\t\t\t\t\t\t\t\t\t\t\t<span class=\"align-middle small\" ng-if=\"item.task.due_date_type=='today'\" rel=\"tooltip\" data-original-title=\"{{item.task.due_date_formatted}}\">Today</span>\n\t\t\t\t\t\t\t\t\t\t\t<span class=\"align-middle small task-item-text\" ng-if=\"item.task.due_date_type=='tomorrow'\" rel=\"tooltip\" data-original-title=\"{{item.task.due_date_formatted}}\">Tomorrow</span>\n\t\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t</span>\n\n\t\t\t\t\t\t\t\t<!--- Status indicator -->\n\t\t\t\t\t\t\t\t<span ng-if=\"item.task.priority !== 0\" ng-switch=\"item.task.priority\" class=\"py-1 pl-0 pr-2 pl-0 mr-2 float-left align-middle\">\n\t\t\t\t\t\t\t\t\t<span class=\"priority-low text-success\" ng-switch-when=\"1\">\n\t\t\t\t\t\t\t\t\t\t<ion-icon class=\"task-item-icon\" name=\"arrow-down-outline\"></ion-icon>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"priority-medium text-warning\" ng-switch-when=\"2\">\n\t\t\t\t\t\t\t\t\t\t<ion-icon class=\"task-item-icon\" name=\"arrow-up-outline\"></ion-icon>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"priority-high text-danger\" ng-switch-when=\"3\">\n\t\t\t\t\t\t\t\t\t\t<ion-icon class=\"task-item-icon\" name=\"arrow-up-outline\"></ion-icon>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t</span>\n\n\t\t\t\t\t\t\t\t<!--- private note -->\n\t\t\t\t\t\t\t\t<span ng-if=\"item.showPrivate\" class=\"float-left align-middle\">\n\t\t\t\t\t\t\t\t\t<span class=\"py-1 pl-0 pr-2 pl-0 mr-2 float-left\" ng-if=\"item.task.is_private\">\n\t\t\t\t\t\t\t\t\t\t<ion-icon class=\"task-item-icon task-item-icon-gray\" name=\"lock-closed-outline\"></ion-icon>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t</span>\n\n\t\t\t\t\t\t\t\t<!--- comments -->\n\t\t\t\t\t\t\t\t<span class=\"float-left align-middle\">\n\t\t\t\t\t\t\t\t\t<a href=\"/projects/task/{{item.task.id}}\" class=\"py-1 pl-0 pr-2 pl-0 mr-2 float-left text-reset\" ng-if=\"item.task.comments_count>0\">\n\t\t\t\t\t\t\t\t\t\t<ion-icon class=\"task-item-icon task-item-icon-gray\" name=\"chatbox-outline\"></ion-icon>\n\t\t\t\t\t\t\t\t\t\t<span class=\"small task-item-text\">{{item.task.comments_count}}</span>\n\t\t\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t\t</span>\n\n\t\t\t\t\t\t\t\t<!--- files -->\n\t\t\t\t\t\t\t\t<span ng-if=\"item.showFiles\" class=\"float-left align-middle\">\n\t\t\t\t\t\t\t\t\t<a href=\"/projects/task/{{item.task.id}}#/filesTab\" ng-if=\"item.task.has_file_storage\" class=\"py-1 pl-0 pr-2 pl-0 mr-2 d-inline-block text-reset\">\n\t\t\t\t\t\t\t\t\t\t<ion-icon class=\"task-item-icon task-item-icon-gray\" name=\"attach-outline\"></ion-icon>\n\t\t\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t\t</span>\n\n\t\t\t\t\t\t\t\t<!-- Status -->\n\t\t\t\t\t\t\t\t<span class=\"float-left align-middle py-1 pl-0 pr-2 pl-0 mr-2\">\n\t\t\t\t\t\t\t\t\t<cla-badge styleclass=\"badge badge-pill badge-secondary\">{{(item.task.status_list | filter : {id: item.task.status_id})[0].name }}</cla-badge>\n\t\t\t\t\t\t\t\t</span>\n\n\t\t\t\t\t\t\t\t<!--- assigned to -->\n\t\t\t\t\t\t\t\t<div ng-if=\"item.showAssignees && item.task.assignees.length !== 0\" class=\"py-1 pl-0 pr-2 pl-0 float-left align-middle\">\n\t\t\t\t\t\t\t\t\t<clang-user-list class=\"users d-inline-block mr-2\" style=\"width: 130px;\" plusnumber=\"{{item.task.assignees.length - 3}}\" on-plus-clicked=\"item.additionalAssigneesClick()\">\n\t\t\t\t\t\t\t\t\t\t<a ng-href=\"{{user.profile_url}}\" ng-repeat=\"assignee in item.task.assignees | limitTo: 3\">\n\t\t\t\t\t\t\t\t\t\t\t<clang-user-list-item img=\"{{assignee.profile_img }}\" name=\"{{assignee.name}}\" profile=\"{{assignee.profile_url}}\"></clang-user-list-item>\n\t\t\t\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t\t\t</clang-user-list>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n\n<div ng-if=\"item.display === 'board'\">\n\n\t<div class=\"task-item form-inline board-task\" as-sortable-item-handle=\"\">\n\t\t<div class=\"list-draggable-area card rounded-corners d-block w-100\" ng-attr-data-no-drag=\"{{item.noDrag()}}\">\n\t\t\t<span class=\"card-status-border\" ng-style=\"{'background-color': item.list.list.colour}\"></span>\n\t\t\t<div class=\"card-body\">\n\t\t\t\t<div class=\"row\">\n\t\t\t\t\t<div class=\"col-md-12\">\n\t\t\t\t\t\t<div class=\"text-break board-task-title\">\n\t\t\t\t\t\t\t<a ng-if=\"item.task.title !== item.task.title_truncated\" ng-href=\"/projects/task/{{item.task.id}}\" rel=\"tooltip\" data-original-title=\"{{item.task.title}}\">{{item.task.title_truncated}}</a>\n\t\t\t\t\t\t\t<a ng-if=\"item.task.title === item.task.title_truncated\" ng-href=\"/projects/task/{{item.task.id}}\">{{item.task.title}}</a>\n\t\t\t\t\t\t\t<a ng-href=\"{{item.task.source.link}}\" ng-show=\"(item.showSource) && (item.task.source) && (item.task.source.name !== '')\">\n\t\t\t\t\t\t\t\t<span class=\"text-muted\">({{item.task.source.name}})</span>\n\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t</div>\n\n\t\t\t\t\t\t<!--- due date -->\n\t\t\t\t\t\t<div class=\"mt-1\" ng-if=\"item.showDate\">\n\t\t\t\t\t\t\t<span ng-if=\"item.task.due_date_formatted != ''\">\n\t\t\t\t\t\t\t\t<span ng-class=\"{'text-danger': item.task.due_date_type=='overdue'}\">\n\t\t\t\t\t\t\t\t\t<span>Due: </span> {{item.task.due_date_formatted}}\n\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"row mt-2\">\n\t\t\t\t\t<div class=\"col-7\">\n\t\t\t\t\t\t<!--- assigned to -->\n\t\t\t\t\t\t<div ng-if=\"item.showAssignees\" class=\"mt-1\">\n\t\t\t\t\t\t\t<clang-user-list class=\"users d-inline-block mr-2\" style=\"width:145px;\" plusnumber=\"{{item.task.assignees.length - 3}}\" on-plus-clicked=\"item.additionalAssigneesClick()\">\n\t\t\t\t\t\t\t\t<a ng-href=\"{{user.profile_url}}\" ng-repeat=\"assignee in item.task.assignees | limitTo: 3\">\n\t\t\t\t\t\t\t\t\t<clang-user-list-item img=\"{{assignee.profile_img }}\" name=\"{{assignee.name}}\" profile=\"{{assignee.profile_url}}\"></clang-user-list-item>\n\t\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t</clang-user-list>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"col-5\">\n\t\t\t\t\t\t<!--- Status indicator -->\n\t\t\t\t\t\t<span class=\"float-right mt-1\" ng-switch=\"item.task.priority\">\n\t\t\t\t\t\t\t<cla-status-indicator color=\"#5cb85c\" badgestyle=\"true\" size=\"x-small\" ng-switch-when=\"1\"><small>Low</small></cla-status-indicator>\n\t\t\t\t\t\t\t<cla-status-indicator color=\"#f0ad4e\" badgestyle=\"true\" size=\"x-small\" ng-switch-when=\"2\"><small>Medium</small></cla-status-indicator>\n\t\t\t\t\t\t\t<cla-status-indicator color=\"#d9534f\" badgestyle=\"true\" size=\"x-small\" ng-switch-when=\"3\"><small>High</small></cla-status-indicator>\n\t\t\t\t\t\t</span>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n\n</div>\n<!--- END View Task -->\n";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./js/model/projectTaskModel.js":
/***/ (function(module, exports) {

(function () {
    var moduleName = 'claromentis.project.tasks_util';
    var module;

    try {
        module = angular.module(moduleName);
    } catch (err) {
        // named module does not exist, so create one
        module = angular.module(moduleName, []);
    }

    module
        .factory('Task', ['$http', taskModelFactory]);

	function taskModelFactory($http)
	{
		var Task = function()
		{
		};

        Task.prototype =
            {
                // Constant to mean 'unsorted' at the end of the list
                DISPLAY_ORDER_NONE: 1e6,
                STATUS_TODO: -1,
                STATUS_COMPLETED: -2,

                restUrl: '/api/projects/task/',

                id: 0,
                project_id: 0,
                title: '',
                description: '',
                due_date: null,
                due_date_formatted: '',
                section_id: 0,
                is_private: false,
                created_by:
                {
                    id: null,
                    name: '',
                    profile_url: '#'
                },
                assignees: [],
                priority: '0',
                is_complete: false,
                date_completed: null,
                duration: '',
                duration_units: '',
                comments_count: 0,
                has_file_storage: false,
                orders: {
                    task: this.DISPLAY_ORDER_NONE,
                    board: this.DISPLAY_ORDER_NONE,
                    board_no_list: this.DISPLAY_ORDER_NONE,
                    my_tasks: this.DISPLAY_ORDER_NONE
                },
                status_id: 0,
                status_list: [],
                source: null,

			    control: {}, // datepicker

                // Using is_complete directly for list visibility and checkbox model causes issues with click events (the model is updated, then visibility assessed and if not visible, the ng-click callback is never run).
                // So use this second copy for visibility that gets updated when the server responds.
                is_complete_server: true,

                tasks: [],
                new_task: new Task(),

			loadFromArray: function(data)
			{
				this.id = data.id;
				this.project_id = data.project_id;
				this.title = data.title;
                this.description = data.description;
                this.due_date = data.due_date;
				this.due_date_formatted = data.due_date_formatted;
				this.due_date_type = data.due_date_type;
                this.section_id = data.section_id;
                this.section_name = data.section_name;
                this.is_private = data.is_private;
				this.created_by = data.created_by;
				this.priority = parseInt(data.priority);
				this.assignees = data.assignees;
				this.is_complete = data.is_complete;
				this.is_complete_server = data.is_complete;
                this.date_completed = data.date_completed === null ? null : parseInt(data.date_completed);
				this.duration = data.duration == null ? '' : data.duration;
				this.duration_units = data.duration_units;
				this.date_created = data.date_created;
				this.comments_count = data.comments_count;
				this.perms = data.perms;
				if (data.source !== undefined)
                {
					this.source = {
						name: data.source.name,
						link: data.source.link
					};
				}
				this.has_file_storage = data.has_file_storage;

				this.orders = {
					list: data.orders.list,
					board: data.orders.board,
					board_no_list: data.orders.board_no_list,
					my_tasks: data.orders.my_tasks
				};

				this.status_id = data.status_id;
				this.status_list = data.status_list;
			},
			add: function(successCallback, errorCallback)
			{
				var data =
				{
                    project_id: this.project_id,
					title: this.title.length <= 255 ? this.title : this.title.substr(0, 255),
                    description: this.description,
					due_date: this.due_date,
					section_id: this.section_id,
					is_private: this.is_private,
                    assignees: this.assignees,
					priority: this.priority,
					duration: this.duration,
					is_complete: this.is_complete
				};
				$http(
					{
						method:'POST',
						url: this.restUrl + 'add',
						data: data,
						task: this,
						successCallback: successCallback,
						errorCallback: errorCallback
					}).then(function(response)
					{
						var task = response.config.task;
						task.id = response.data.id;
						task.project_id = response.data.project_id;
						task.title = response.data.title;
						task.description = response.data.description;
						task.due_date = response.data.due_date;
						task.due_date_formatted = response.data.due_date_formatted;
						task.due_date_type = response.data.due_date_type;
						task.section_id = response.data.section_id;
						task.is_private = response.data.is_private;
						task.created_by = response.data.created_by;
						task.assignees = response.data.assignees;
						task.perms = response.data.perms;
						task.priority = response.data.priority;
						task.is_complete = response.data.is_complete;
						task.duration = response.data.duration;
						task.duration_units = response.data.duration_units;
						task.is_complete_server = task.is_complete;

                        response.config.successCallback(response.data);
                    }, function (response) {
                        response.config.errorCallback(response.data);
					});
			},
			update: function(successCallback, errorCallback)
			{
				var data =
				{
					project_id: this.project_id,
					title: this.title.length <= 255 ? this.title : this.title.substr(0, 255),
                    description: this.description,
					due_date: this.due_date,
					is_private: this.is_private,
                    assignees: this.assignees,
                    priority: this.priority,
					duration: this.duration,
					is_complete: this.is_complete
				};

                // An array should contains only ids not user's objects
                if (Array.isArray(this.assignees) &&
                    this.assignees.length > 0  &&
                    this.assignees[0].hasOwnProperty('id')
                ) {
                    data.assignees = this.getUsersIds(this.assignees);
                }

				$http(
					{
						method:'PUT',
						url: this.restUrl + this.id,
						data: data,
						task: this,
						successCallback: successCallback,
						errorCallback: errorCallback
					}).then(function(response)
                    {
                        var task                = response.config.task;
                        task.id                 = response.data.id;
                        task.project_id         = response.data.project_id;
                        task.title              = response.data.title;
                        task.description        = response.data.description;
                        task.due_date           = response.data.due_date;
                        task.due_date_formatted = response.data.due_date_formatted;
                        task.due_date_type      = response.data.due_date_type;
                        task.is_private         = response.data.is_private;
                        task.created_by         = response.data.created_by;
                        task.assignees          = response.data.assignees;
                        task.perms              = response.data.perms;
                        task.priority           = response.data.priority;
                        task.is_complete        = response.data.is_complete;
                        task.duration           = response.data.duration;
                        task.duration_units     = response.data.duration_units;
                        task.is_complete_server = task.is_complete;

                        response.config.successCallback(task);
                    }, function (response) {
                        response.config.errorCallback(response.data);
                    });
				},
                delete: function (successCallback, errorCallback) {
                    $http(
                        {
                            method: 'DELETE',
                            url: this.restUrl + this.id,
                            section: this,
                            successCallback: successCallback,
                            errorCallback: errorCallback
                        }).then(function (response) {
                        response.config.successCallback(response.data.id);
                    }, function (response) {
                        response.config.errorCallback(response.data);
                    });
                },
                setComplete: function (successCallback, errorCallback) {
                    $http(
                        {
                            method: 'PUT',
                            url: this.restUrl + this.id + '/complete',
                            task: this,
                            successCallback: successCallback,
                            errorCallback: errorCallback
                        }).then(function (response) {
                        response.config.task.is_complete_server = true;
                        response.config.task.status_id = response.config.task.STATUS_COMPLETED;
                        response.config.successCallback(response.config.task, response.data);
                    }, function (response) {
                        response.config.errorCallback(response.config.task, response.data);
                    });
                },
                setIncomplete: function (successCallback, errorCallback) {
                    $http(
                        {
                            method: 'PUT',
                            url: this.restUrl + this.id + '/incomplete',
                            task: this,
                            successCallback: successCallback,
                            errorCallback: errorCallback
                        }).then(function (response) {
                        response.config.task.is_complete_server = false;
                        response.config.task.status_id = response.config.task.STATUS_TODO;
                        response.config.successCallback(response.config.task, response.data);
                    }, function (response) {
                        response.config.errorCallback(response.config.task, response.data);
                    });
                },
                setStatus: function (successCallback, errorCallback) {
                    if (!successCallback)
                        successCallback = function () {
                        };

                    if (!errorCallback)
                        errorCallback = function () {
                        };

                    var status      = this.status_id;
                    var is_complete = this.status_id === this.STATUS_COMPLETED;

                    $http({
                        method: "PUT",
                        url: '/api/projects/task/' + this.id + '/status',
                        task: this,
                        data: {
                            status: status
                        },
                        successCallback: successCallback,
                        errorCallback: errorCallback
                    }).then(function (response) {
                        response.config.task.is_complete_server = is_complete;
                        response.config.task.is_complete        = is_complete;
                        response.config.successCallback(response.config.task, response.data);
                    }, function (response) {
                        response.config.errorCallback(response.config.task, response.data);
                    });
                },
                moveToSectionId: function (section_id) {
                    this.section_id = section_id;
                },
                setDisplayOrder: function (display_order) {
                    this.display_order = display_order;
                },

                /**
                 * Change an array with objects contains assigned user to array with ids
                 *
                 * @param associative_array Array
                 * @returns [1,2,3,..] Array
                 */
                getUsersIds: function (associative_array) {
                    var assignees = [];

                    associative_array.map(function(assignee) {
                        if (!assignee.hasOwnProperty('id'))
                            return;

                        assignees.push(assignee.id);
                    })

                    return assignees;
                }
            };

        return Task;
    }
}());


/***/ }),

/***/ "./js/projects.tasks_util.js":
/***/ (function(module, exports, __webpack_require__) {

angular.module('claromentis.project.tasks_util', ['claromentis.projects.widgets']);
__webpack_require__("./js/model/projectTaskModel.js");
__webpack_require__("./js/task/task.directive.js");


/***/ }),

/***/ "./js/task/task.directive.js":
/***/ (function(module, exports, __webpack_require__) {

var task_template = __webpack_require__("./html/directives/task.directive.html");
var taskItemLoaded = taskItemLoaded || false;

(function()
{
	var moduleName = 'claromentis.project.tasks_util';
	var module = angular.module(moduleName);

	if (!taskItemLoaded)
	{
		module
			.directive('projectTaskItem', projectTaskItem);

        projectTaskItem.$inject = ['task_edit_service', 'userListService'];
		function projectTaskItem(taskEditService, userListService) {
			return {
				restrict: 'E',
				templateUrl: function(elem,attrs) {
					return attrs.templateUrl || task_template
				},
				scope: {
					task: '=',
                    showProjectName: '=',
                    showSectionName: '=',
                    currentUserId: '@',
					useDragAndDrop: '@',
                    display: '@',
					listPrefix: '@',
					taskUpdate: '&',
					taskDelete: '&',
					taskCompleteToggled: '&',
					titleLength: '@',
                    showAssignees: '<',
                    list: '<',
                    showSource: '@',
                    allowDrag: '<'
				},
				controllerAs: 'item',
				bindToController: true,
				controller: controller,
				link: link
			};

			function controller()
			{
				var ctrl = this;
                ctrl.showSource = !!ctrl.showSource;
				ctrl.$element = null;

                this.$onInit = function() {
                    ctrl.updateTitle();

                    // Set default if needed
                    if ((ctrl.showAssignees !== 'others') &&
                        (ctrl.showAssignees !== 'none'))
                    {
                        ctrl.showAssignees = 'all';
                    }

                    if (ctrl.currentUserId === undefined)
                        ctrl.currentUserId = 0;
                    else
                        ctrl.currentUserId = parseInt(ctrl.currentUserId);

                    // Default to allowing dragging if unspecified
                    if (ctrl.allowDrag === undefined)
                        ctrl.allowDrag = true;
                };

				ctrl.startTaskEdit = function(event, id)
				{
					event.preventDefault();
					angular.element('.js-task_edit_button_' + id).tooltip('hide');
					taskEditService.startEdit(ctrl.task, ctrl.$element);
				};

				ctrl.completeToggled = function()
				{
					ctrl.taskCompleteToggled({task: ctrl.task});
				};

				ctrl.taskUpdated = function(task)
				{
                    ctrl.taskUpdate({task: ctrl.task});

                    ctrl.task.id = task.id;
                    ctrl.task.title = task.title;
                    ctrl.task.description = task.description;
                    ctrl.task.project_id = task.project_id;
                    ctrl.task.assignees = task.assignees;
                    ctrl.task.due_date = task.due_date;
                    ctrl.task.priority = parseInt(task.priority);
                    ctrl.task.is_private = task.is_private;
                    ctrl.task.duration = task.duration;
                    ctrl.task.duration_units = task.duration_units;
                    ctrl.task.due_date_type = task.due_date_type;
                    ctrl.task.due_date_formatted = task.due_date_formatted;
                    ctrl.task.perms = task.perms;

					ctrl.updateTitle();
				};

				ctrl.updateTitle = function()
				{
					// Truncate the title if needed and requested
					var max_length = parseInt(ctrl.titleLength);
					if (typeof ctrl.titleLength === 'undefined')
						max_length = 0;
					ctrl.task.title_truncated = ctrl.task.title;
					if ((max_length !== 0) &&
						(ctrl.task.title.length > max_length))
					{
						ctrl.task.title_truncated = ctrl.task.title_truncated.substring(max_length, 0) + '…';
					}
				};

				ctrl.taskDeleted = function(task)
                {
                    if (ctrl.taskDelete !== undefined)
                        ctrl.taskDelete(task);
                };

                ctrl.getAssignees = function()
                {
                    if (ctrl.showAssignees === 'none')
                        return [];
                    if (ctrl.showAssignees === 'all')
                        return ctrl.task.assignees;

                    // Must be 'others' so strip out current user
                    var userId = parseInt(ctrl.currentUserId);
                    var assignees = [];
                    for (var assigneeIndex = 0; assigneeIndex < ctrl.task.assignees.length; assigneeIndex++)
                    {
                        if(ctrl.task.assignees[assigneeIndex].id !== userId)
                            assignees.push(ctrl.task.assignees[assigneeIndex]);
                    }

                    return assignees;
                };

				ctrl.noDrag = function()
                {
                    return ctrl.allowDrag === false ? true : undefined;
                };

                ctrl.additionalAssigneesClick = function() {
                    userListService.showUsersList(ctrl.task.assignees);
                };
			}

			function link(scope, element, attrs, controller)
			{
			    controller.$element = element;
			    controller.$element.on('cancelEdit', function(event){
                });
                controller.$element.on('editComplete', function(event, task){
                    controller.taskUpdated(task);
                });
                controller.$element.on('taskDeleted', function(event, task){
                    controller.taskDeleted(task);
                });

				// Default to showing all parts unless told otherwise
				controller.showEdit = (attrs.showEdit !== 'false');
				controller.showPrivate = (attrs.showPrivate !== 'false');
				controller.showDate = (attrs.showDate !== 'false');
				controller.showFiles = (attrs.showFiles !== 'false');
				controller.showComments = (attrs.showComments !== 'false');
			}
		}
	}

	taskItemLoaded = true;
}());


/***/ }),

/***/ 26:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__("./js/projects.tasks_util.js");


/***/ })

/******/ })});;