(function()
{
	var moduleName = 'projectDetailApp';

	angular.module(moduleName)
        .filter("sanitize", ['$sce', sanitizeFilter])
		.controller("projectTeamCtrl", ["$scope", "$http", 'growl.service', projectTeamController]);

    function sanitizeFilter($sce)
    {
        return function(htmlCode){
            return $sce.trustAsHtml(htmlCode);
        }
    }

	var entityMap = {
		"&": "&amp;",
		"<": "&lt;",
		">": "&gt;",
		'"': '&quot;',
		"'": '&#39;',
		"/": '&#x2F;'
	};

	var AUTOMATIC_COLOUR_COUNT = 10;

	function escapeHtml(string) {
		return String(string).replace(/[&<>"'\/]/g, function (s) {
			return entityMap[s];
		});
	}

	function projectTeamController($scope, $http, growl)
	{
		$scope.project_members = project_members.team;
		$scope.memberCount = project_members.total_members;
		$scope.currentPage = 1;
		$scope.pageSize = project_members.page_size;
		$scope.project_member_perms = project_members.column_perms;
		$scope.project_perms = project_perms;
		$scope.member_role = '';

		$scope.project_id = project_id;

		// Model for user editing/adding. Because we are using the userpicker component for adding it isn't possible to include that
		$scope.user_values =
		{
			type: 'add',
			role: '',
			responsibility: '',

			// Used for edit only
			user_id: 0,
			profile_url: '',
			name: ''
		};

		// Angulars model won't be connected yet so initialise the select2 after a short delay
		setTimeout(function()
		{
			$('#inputResponsibility').select2(
				{
					ajax: {
						url: "/api/projects/responsibilities",
						dataType: 'json',
						delay: 250,
						data: function (params) {
							return {
								q: params.query, // search term
								page: params.page
							};
						},
						processResults: function (data) {
							return {results: data.data};
						},
						cache: true
					},
					createSearchChoice:function(term, data) {
						if ($(data).filter(function() {
								return this.text.localeCompare(term)===0;
							}).length===0) {
							return {id:term, text:term};
						}
					},
					tags: true,
					multiple: false,
					placeholder: '(optional)',
					allowClear: true,
					maximumSelectionSize: 1,
					minimumInputLength: 0
				}
			);
		}, 50);

		$scope.updateTeamCount = function()
		{
			var count = $scope.memberCount;
			$scope.$root.$broadcast('setTeamTabCount', count);
		};

		$scope.updateTeamCount();

		$scope.showEditMember = function(event, member)
		{
			event.preventDefault();
			// Hide the tooltip

			angular.element('#edit-link-' + member.user_id).tooltip('hide');

			$scope.user_values.user_id = member.user_id;
			$scope.user_values.profile_url = member.profile_url;
			$scope.user_values.name = member.full_name;
			$scope.user_values.responsibility = member.project_responsibility;
			var responsibility = angular.element('#inputResponsibility');
			responsibility.html('');
			responsibility.append('<option selected value="'+member.project_responsibility+'">'+escapeHtml(member.project_responsibility)+'</option>');
			setTimeout(function(){angular.element('#inputResponsibility').trigger('change');}, 0);

			angular.element('#teamModal').modal('show');
		};

		$scope.editMembers = function(event)
		{
			event.preventDefault();

			// get selected responsibility from tab Team
			$scope.user_values.responsibility = angular.element('#inputResponsibility').val();

            if ($scope.user_values.responsibility === null) {
                $scope.user_values.responsibility = '';
            }

			var users = [];

			users.push($scope.user_values.user_id);

			$('#teamModal').modal('hide');

			for (var i = 0; i < users.length; i++)
			{
				var url = '/api/projects/' + $scope.project_id + '/member/' + users[i];
				$http.put(url, {}, {
                    params: {
                        responsibility: $scope.user_values.responsibility
                    }
				}).then(function(result)
				{
					if (result.data.result)
					{
						// Overwrite the user if they appear in the list
                        // We must preserve the list order, and the user might not
                        // be on the currently loaded page (because function is
                        // called asynchronously
					    for (var j = 0; j < $scope.project_members.length; j++)
						{
							if ($scope.project_members[j].user_id == result.data.entry.user_id)
								$scope.project_members[j] = result.data.entry;
						}

						$scope.updateHistoryLog();
					} else
					{
						cla.showMessage(result.data.message, '', true);
					}
				});
			}
		};

		$scope.updateHistoryLog = function()
		{
			$scope.$root.$broadcast('updateHistoryLog', null);
		};

		$scope.getColourForRole = function(roleName)
        {
            // Fast hash algorithm from https://stackoverflow.com/a/8831937

            // For this automatic version of colours we are getting a hash of the role name and using modular division to reduce it to the size
            // of our colour table. The reason for doing this rather then using ID or position of the role in the project is to keep the
            // colours consistent between projects for the same role name. so "PM" will always be the same colour regardless of where it is

            var hash = 0;
            if (roleName.length === 0) {
                return hash;
            }
            for (var i = 0; i < roleName.length; i++) {
                var char = roleName.charCodeAt(i);
                hash = ((hash<<5)-hash)+char;
                hash = hash & hash; // Convert to 32bit integer
            }

            return (Math.abs(hash) % AUTOMATIC_COLOUR_COUNT) + 1;
        };

		$scope.pageChanged = function(newPage) {
		    $("#team-list-spinner").show();
		    $("#team-list-table").addClass("loading-table");
		    $http({
                method: 'GET',
                url: '/api/projects/v2/' + $scope.project_id + '/members',
                params: {
                    offset: (newPage - 1) * $scope.pageSize,
                    limit: $scope.pageSize
                }
            }).then(function(data) {
                if (data.data) {
                    var members = data.data.data;

                    $scope.project_members.length = 0;
                    for (var i = 0; i < members.length; i++)
                        $scope.project_members.push(members[i])

                    $("#team-list-spinner").hide();
                    $("#team-list-table").removeClass("loading-table");
                }
            }, function(data) {
                var error = "Failed to load members page " + newPage;

                if (data.data && data.data.message)
                    error = error + ": " + data.data.message;

                console.error(error);
                growl.showError(lmsg("projects.team.page_load_error"));
            });
        };
    }
}());
