(function()
{
	var moduleName = 'claromentis.project';
	var module;

	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module
		.directive('claDatePicker', ['$timeout', claDatePicker]);

	function claDatePicker($timeout)
	{
		controller.$inject = ['$scope'];
		return {
			restrict: 'E',
			require: '^ngModel',
			templateUrl: '/intranet/projects/html/components/date_picker.html',
			scope: {
				ngModel: '=',
				control: '='
			},
			controller: controller,
			link: link
		};

		function controller($scope)
		{
            this.$onInit = function() {
                $scope.control.reset = function(){
                    angular.element('#' + $scope.id + '-inner').datetimepicker('clear');
                };
            };
		}

		function link(scope, iElement, iAttrs, ctrl)
		{
			scope.id = iAttrs.id;
			scope.name = iAttrs.name;
			scope.ctrl = ctrl;


			ctrl.$viewChangeListeners.push(function() {
				scope.$eval(iAttrs.ngChange);
			});

			angular.element('#' + scope.id + '-inner').on('blur', function(){
				element = $('#' + scope.id + '-inner');
				newval = element.val();
				ctrl.$setViewValue(newval);
			});

			$timeout(function()
			{
				date_picker_init(angular.element('#' + scope.id + '-inner'));
			}, 0);
		}
	}
}());
