(function()
{
    var moduleName = 'claromentis.project';
    var template = require('../../html/directives/history_changes.directive.html');

    angular.module(moduleName)
        .directive('historyChanges', historyChanges);

    function historyChanges()
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                changes: '<'
            },
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            ctrl.isSpecialUpdateType = function(type)
            {
                var specialTypes = [
                    'assignee',
                    'assignees',
                    'priority',
                    'status',
                    'list',
                    'is_private'
                ];
                return specialTypes.indexOf(type) > -1;
            };
        }
    }
}());
