(function()
{
    var moduleName = 'claromentis.project';
    var template = require('../../html/directives/history_priority.directive.html');

    angular.module(moduleName)
        .directive('historyPriority', historyPriority);

    function historyPriority()
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                priority: '@'
            },
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            ctrl.getPriorityName = function()
            {
                return priorityLookup[ctrl.priority];
            }
        }
    }

    var priorityLookup = {
        0: lmsg('projects.task.priority.none'),
        1: lmsg('projects.task.priority.low'),
        2: lmsg('projects.task.priority.medium'),
        3: lmsg('projects.task.priority.high')
    };
}());
