define(['./confirm.component.html'], function (template)
{
    var Confirm = {
        bindings: {},
        templateUrl: template,
        transclude: true,
        controller: [
            'confirmService',
            function (confirmService) {
                var ctrl = this;

                ctrl.options = {
                    title: '',
                    message: '',
                    icon: '',
                    mode: ''
                };

                ctrl.settings = function(settings) {
                    var values = {
                        title: '',
                        message: '',
                        icon: 'alert-circle-outline',
                        mode: 'cancel_delete'
                    };
                    ctrl.options = angular.extend(values, settings);
                };
                confirmService.registerConfirmDialog(ctrl.settings);

                ctrl.confirm = function() {
                    confirmService.resolve();
                };

                ctrl.cancel = function() {
                    confirmService.reject();
                };
            }
        ]
    };

    return Confirm;
});
