define(['./toggle_switch.component.html'], function (template)
{
    var ToggleSwitch = {
        bindings: {
            ngModel: '=',
            labels: '@',
            labelOn: '@',   // Can't be used until the web component property can be renamed away from 'ontext'
            labelOff: '@',  // Also not used due to above limitation
            large: '@',
            name: '@',
            disabled: '@'
        },
        require: { ngModelCtrl: 'ngModel' },
        templateUrl: template,
        transclude: true,
        controller: function () {
            var ctrl = this;

            ctrl.$onInit = function() {
                if (ctrl.disabled === undefined)
                    ctrl.disabled = false;
            };

            ctrl.offLabel = function() {
                if (ctrl.labels !== 'showhide')
                    return lmsg('projects.details.not_grouped');
                else
                    return lmsg('projects.details.hide');
            };

            ctrl.onToggledOn = function($event) {
                $event.preventDefault();

                ctrl.ngModel = true;
                ctrl.ngModelCtrl.$setViewValue(ctrl.ngModel);
            }

            ctrl.onToggledOff = function($event) {
                $event.preventDefault();

                ctrl.ngModel = false;
                ctrl.ngModelCtrl.$setViewValue(ctrl.ngModel);
            }
        }
    };

    return ToggleSwitch;
});
