(function()
{
    var template = require('../../html/project/tasks_board_section.directive.html');
	var moduleName = 'claromentis.project';

	angular.module(moduleName)
        .directive('clangTasksBoardSection', tasksBoardSection);

    tasksBoardSection.$inject = ['$timeout', 'tasksService', 'confirmService'];
    function tasksBoardSection($timeout, service, confirmService) {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                list: '<',
                allowDrag: '<'
            },
            transclude: true,
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            ctrl.editName = '';
            ctrl.editColour = '';
            ctrl.editMode = false;
            ctrl.expanded = true;
            ctrl.hasEditPerms = service.canEditTasks();

            this.$onInit = function() {
                // For new lists, jump straight to editing the name
                if (ctrl.list.isNew !== undefined && ctrl.list.isNew)
                    ctrl.startRename();
            };

            ctrl.collapseList = function(listId)
            {
                service.collapseList(listId);
            }

            ctrl.expandList = function(listId)
            {
                service.expandList(listId);
            }

            ctrl.startEdit = function($event) {
                if ($event !== undefined)
                    $event.preventDefault();

                ctrl.editName = ctrl.list.listName;
                ctrl.editColour = ctrl.list.list.colour;
                ctrl.editMode = true;

                $timeout(function() {
                    angular.element('#list_' + ctrl.list.listId).focus();
                }, 0);
            };

            ctrl.cancelEdit = function($event) {
                $event.preventDefault();

                ctrl.editMode = false;
                ctrl.list.isNew = false;
            };

            ctrl.edit = function($event) {
                if ($event !== undefined)
                    $event.preventDefault();

                service.editList({
                    id: ctrl.list.listId,
                    name: ctrl.editName,
                    colour: ctrl.editColour
                });
                ctrl.editMode = false;
                ctrl.list.isNew = false;
            };

            ctrl.delete = function($event) {
                if ($event !== undefined)
                    $event.preventDefault();

                confirmService.show({
                    title: lmsg('projects.tasks.delete_list.title'),
                    message: lmsg('projects.tasks.delete_list.message', ctrl.list.listName)
                }).then(function() {
                    service.deleteList(ctrl.list);
                }, function() {
                });
            };

            ctrl.noDrag = function()
            {
                return ctrl.allowDrag === false ? true : undefined;
            };
        }
    }
}());
