# Projects Change Log

## 4.0.6 - 21st August 2025

### Bug fixes

- 13952dad...ff3f5299 FRAM-1087 Fixed PHP 8 compatibility for migrations

### Developer notes

- Merged upstream changes from 3.1.9

## 4.0.5 - 12th August 2025

### Developer notes

- Merged upstream changes from 3.1.8
- Rebuilt assets

## 4.0.4 - 29th July 2025

### Bug fixes

- 6d1611e9 BT-5351 Fixed an error that occurred when attaching files to comments

## 4.0.3 - 28th July 2025

### Developer notes

- Merged upstream changes from 3.1.7

## 4.0.2 - 4th July 2025

### Developer notes

- Merged upstream changes from 3.1.6

## 4.0.1 - 16th June 2025

### Developer notes

- Merged upstream changes from 3.1.5

## 4.0.0 - 9th June 2025

- Stable release

## 4.0.0-beta - 16th April 2025

- !177 FRAM-1040 Symfony 5 compatibility
- 34cd5f21...fafc9742 BT-5249 Fixed a PHP 8 incompatibility error that affected the 'My Tasks' Pages component
- Merged upstream changes from 3.1

## 4.0.0-alpha2 - 28th November 2024

- Merged upstream changes from 3.0

## 4.0.0-alpha - 14th November 2024

- FRAM-954 Claromentis 10 compatibility

## 3.1.9 - 21st August 2025

### Improvements

- !189 PRJ-639 Added a notification for project team members when a new topic is created

## 3.1.8 - 6th August 2025

### New features

- !191 PRJ-642 Added new project status: Completed

## 3.1.7 - 17th July 2025

### Bug fixes

- !186 UIUX-925 Fixed projects information modal text alignment issue
- !188 BT-5351 Fixed an error that occurred when commenting with file attachments on ad-hoc tasks

## 3.1.6 - 4th July 2025

### Improvements

- !185 PRJ-633 Updated Projects overview user interface

## 3.1.5 - 16th June 2025

### Bug fixes

- !183 BT-5341 Disco 049186 Fixed slow performance with large numbers of project files
- !184 PRJ-636 Disco 049391 Fixed error and added logging for unexpected date data in history

### Developer notes

- !183 BT-5341 Disco 049186 Bumped up Core version requirement to 9.5.3 because a new Documents method in that version is needed for faster performance

## 3.1.4 - 16th April 2025

### Developer notes

- Merged upstream changes from 2.1.13

## 3.1.3 - 7th March 2025

### Bug fixes

- !181 BT-3332 Resolved JavaScript error and broken project list when viewing company details

## 3.1.2 - 13th February 2025

### Improvements

- !179 PRJ-631 Expanded width of Projects edit/add task modals

### Bug fixes

- !180 BT-4958 BT-5141 Resolved issues with the roles & rights workflow when creating a new project 

## 3.1.1 - 15th January 2025

### Improvements

- !170 PRJ-625 Updated the Projects Task Description to use a rich text editor.

## 3.1.0 - 20th November 2024

<!-- PRJ-628 Please release a minor version due to the new features -->

### New features

- !172 PRJ-628 Disco 047122 Add configuration options for the Document Management System View (DMSV) in the Projects Admin Panel

## 3.0.14 - 7th November 2024

### Bug fixes

- !171 Resolved an issue that prevented image uploads in the rich text editor.
- !173 BT-4975 Fixed Admin side menu page select highlight issue
- !174 PRJ-629 Fixed link to task urls in German notification template

## 3.0.13 - 18th October 2024

- !169 BT-4903 Added missing German notification templates

## 3.0.12 - 12th September 2024

### Bug fixes

- !168 PRJ-627 Reinstated missing Topic and Edit Topic breadcrumbs

## 3.0.11 - 19th June 2024

- !167 BT-4696 French localisation update
- !166 BT-4684 German localisation update

## 3.0.10 - 14th May 2024

### Bug fixes

- Merged upstream migration from 2.1.12

## 3.0.9 - 4th April 2024

### Bug fixes

- !164 BT-4378 Fixed Projects folders icon view display by increasing width amongst icons

## 3.0.8 - 26th March 2024

### Bug fixes

- !160 BT-4516 Fixed missing multiple assignee filter on Task page
- !162 BT-4524 Fixed layout and visibility issues with the Project tasks pagination buttons
- !162 BT-4551 Fixed an issue where Projects tasks pagination did not correctly display the selected page of results 
- Merged upstream changes from 2.1.12

## 3.0.7 - 19th February 2024

- Merged upstream changes from 2.1

## 3.0.6 - 22nd November 2023

### Improvements

- !156 BT-4224 Updated the Project rights "more information" to display as a button

### Bug fixes

- !157 BT-4299 Fixed issue with the adding a team member button displayed incorrect tab  

## 3.0.5 - 26th September 2023

- Merged upstream changes from 2.1.10

## 3.0.4 - 10th August 2023

### Bug fixes

- !154 BT-4091 Added support for team phone numbers as links

## 3.0.3 - 28th February 2023

- Merged upstream changes from 2.1.9

### Bug fixes

- fb6946f1 BT-3849 Fixed issue with layout and padding of Projects topics table

## 3.0.2 - 12th December 2022

### Improvements

- Merged upstream changes from 2.1.7
- !4 BOOTY-582 Replaced utility classes usages with Bootstrap 4 standard utility classes
- FRAM-838 Added menu item registration

### Bug fixes

- BOOTY-554 Fixed display issues with the My Tasks component
- BOOTY-553 Fixed issue with My tasks component rounded corners not applying correctly
- BT-3765 Fixed minor issue where tasks 'list expansion' button doesn't work if a user clicks on a section outside of the icon

## 3.0.1 - 5th August 2022

### Improvements

- 18cb3f7b BOOTY-500 BOOTY-541 Updated My Projects and My Tasks pages component IDs so it uses the new class structure
- d0f29695 BOOTY-502 Updated Projects card background colour for reports module
- FRAM-657 Updated Reports Schema icon from Glyphicon to SVG
- FRAM-471 Declared support for PHP 8.1

## 3.0.0 - 28th June 2022

### New features
- !142 BT-596 Swap "New List" and "New task" buttons to use a modal

### Bug fixes
- 182f845c BOOTY-420 Fixed some small bugs in projects BT-3369 projects tasks filter sizing issue | BT-3370 removed localisation code which has previously been removed | BT-3383 corrected task 'Sort by' buttons on smaller screens.
- 9a5eda78 BOOTY-420 Updated Glyphicons to use Ionicons in task modal and delete task/list modal.

### Developer notes
- 81015f0a Migrated localization phrase `projects:toolbar:discussions.body` from Discuss module

## 3.0.0-beta2 - 26th April 2022

### Bug fixes
- 66c1fa81 BT-3333 Fixed issue with project description not displaying correctly when tables are added
- 2250bff0 BOOTY-420 Some design improvements to projects including fixing design of dropdown menus and adding the new 'close-on-select' attribute
- 1fb7ef24 BOOTY-420 Small fixes to projects after merge forward
- de69aad5 BOOTY-420 Design fixes and tweaks to dropdowns

## 3.0.0-beta - 28th February 2022

* Claromentis 9 compatibility

### Developer notes

* !143 PRJ-594 Wrapped component `cla-checkbox` into AngularJS directive `clang-checkbox`
* !143 PRJ-594 Added a new directive `clang-checkbox`

## 2.1.13 - 3rd April 2025

### Bug fixes

* !175 BT-5031 Disco 047517 Notifications and history from private tasks are filtered to the users that can view the task

## 2.1.12 - 19th March 2024

### Improvements

* !163 BT-4553 Disco 044089 Improved performance of the "My Tasks" component

## 2.1.11 - 19th February 2024

### Bug fixes

* !159 BT-4245 Disco 042830 Disco 043221 Fixed Bootstrap accordion links not working in Project information (CKEditor content)

## 2.1.10 - 26th September 2023

* !155 PRJ-623 Disco 42703 Assigned private tasks were not visible to the assignee in some "My task" lists

## 2.1.9 - 24th February 2023

* FRAM-869 Rebuilt assets

## 2.1.8 - 9th December 2022

* !153 FRAM-859 Rebuilt assets to match AngularJS 1.8.3 from core

## 2.1.7 - 9th September 2022

### Bug fixes
* !151 BT-3560 disco 38657 Added indexes to projects_task table to speed up gathering task lists
* 54ac5f90 Fixed errors when creating Projects reports with Reports module if no projects have been created yet

## 2.1.6 - 3rd August 2022

### Bug fixes
* !148 PRJ-620 Register the module plugin with its DMSV dependency
* !150 BT-3407 Auto-create a new default tasks list when a user is adding a new task and all lists have been removed

## 2.1.5 - 7th June 2022

### Improvements

* 7cff8581 PRJ-617 The My Projects pages component can now be displayed as a single column width

## 2.1.4 - 12th May 2022

### Improvements

* 1ae38f6a Changed localisation shown when there are no tasks to display


## 2.1.3 - 18th March 2022

### Bug Fixes

* !146 BT-3052 Task counts in the side bar now update automatically when changes are made
* !147 BT-3300 Admin->communication notification list could vanish if system notifications are hidden

## 2.1.2 - 8th February 2022

### Bug Fixes

* !145 BT-3166 Deleting a project showed a dark screen with no confirmation

## 2.1.1 - 26th November 2021

### Bug Fixes

* !141 BT-3101 Fixed issue with board statuses disappearing on edit

## 2.1.0 - 9th November 2021

### Bug fixes
* !129 PRJ-560 Fixed migration of existing comments to a new default topic
* !126 PRJ-562 Fixed the Topics Component missing topics that had no comments.
* 70ba5159 PRJ-569 Fixed project team members pagination
* 154dfb85 BT-3004 Added missing localisation for project and task deletion options in Admin > Projects > Communication.
* cd86abd9 7c31e7a7 PRJ-572 Topic participants are now sorted by most recent comment in the topics list
* !130 PRJ-570 Fixed empty Task List component on the Project Overview page for projects that aren't live
* !131 PRJ-577 Fixed link `View all` in My Tasks Component
* !128 PRJ-566 Copy files from topics comments to the Discussions folder
* !135 PRJ-568 Fixed draggable list/status items during editing
* !133
  * PRJ-581 Updating a task description now updates the page without a refresh
  * Descriptions did not get saved for new tasks
  * Tasks could not be deleted on the tasks page
* !138 PRJ-583 Fixed delete modal window in the project's details view
* !132 PRJ-575 Fixed intermittent JavaScript rendering error due to duplicate module definitions and script loading order
* !140 PRJ-584 Field `List` in `New Task` modal is now updating when the task section is added or deleted

## 2.1.0-beta - 20th October 2021

### Bug fixes
* !116 PRJ-389 Assigned user with "Edit own task" right could not complete/update status via the task page.
* !117 PRJ-554 Adding a new task could show "0000-01-01" for the default due date when some short date formats were used.
* !117 BT-2986 Changed task entries to show due date in short date format.

### New features
* !55 !95 !97 !98 PRJ-307 PRJ-309 PRJ-310 PRJ-314 PRJ-316 PRJ-318 Add, edit and view multiple task assignees
* !103 PRJ-23 Project tasks can be viewed and manipulated on a board layout with statuses as columns
* !23 PRJ-80 Project topics: project discussion is now composed of multiple separate topics which can be created, edited and deleted by project managers
* !107
  * PRJ-64 A projects overview dashboard has been added as the default view of a project instead of the tasks page
  * PRJ-147 Navigation within a project is now achieved on the left instead of by tabs at the top
* !121 PRJ-163 Tasks list view mode buttons have been make simpler to understand

### Breaking Changes
* `Claromentis\Projects\Controller\TaskController`
  * `task.assigned_to` is no longer filled by default values (id, name, profile URL and image), and will now contain `null` if nobody is assigned to the task or first assigned user

### Developer notes
* !45 !94 PRJ-275 PRJ-168 AngularJS applications split up between side panel and the main page to allow better dynamic layouts for mobile
* !54 PRJ-34 Add/edit task form moved to a modal
* !127 PRJ-559 Users list popup AngularJS component available to use anywhere
* BT-2781 PRJ-549 Updated Core constraint to `~8.11.15 | >=8.12.13`

## 2.0.3 - 20th October 2021

### Developer notes

- 723b050c Fixed premature database connections by lazy-resolving the notifications subscriber

## 2.0.2 - 6th August 2021

### Improvements

* ce186d88 Introduced localization phrase for Project RAG Status: `projects.project.rag_status`

### Bug fixes

* !46 Fixed some errors in the uninstallation script
* 6927eabb PRJ-443 Fixed task completion notification name localisation in Communication settings
* !102 PRJ-528 Fixed the "Add extended team member" notification preference in Admin > Projects > Communication also setting the "Team member responsibility changed" preference; they can now be set separately
* !106 PRJ-533 Fixed issue where pagination of the project listing page could be broken by projects being followed by multiple users.

### Developer notes

* !101 PRJ-317 Added deprecation notice to methods: `SetUserFilter()` and `GetUserFilter()` in the class `TaskListFilter`. Methods will be replaced in `v2.1`

## 2.0.1 - 11th May 2021

* Merged forward fixes from 1.6.3

## 2.0.0 - 15th April 2021

### Improvements
* !12 Phase 1: Project edit page streamlining, project list, automatic document storage creation and no default metadata
    * PRJ-41 Project description now uses a full CKEditor instead of BBCode.
    * PRJ-42, PRJ-43, PRJ-48, PRJ-40 "Additional Info" tab contents are now on the main project edit page.
    * PRJ-44 On a fresh install no metadata is created by default.
    * PRJ-63 Main projects list page design updates.
    * PRJ-49 Document storage is now automatically created for new projects.
    * PRJ-50 On new install a Projects documents folder (localised version of "Projects") will be automatically created and use as the projects root folder.
* !24 PRJ-164 Tasks now have a status instead of a simple "completed" flag
* !64 PRJ-342 Typing into the project list search bar no longer causes many updates to the list as you type. It now updates once when you stop typing.
* !52
  * PRJ-11 Notifications are now sent to team members mentioned in a Project/Task comment.
  * PRJ-12 A notification is now sent when a task is marked as not completed.
* !21 PRJ-121 project folders can no longer be deleted from Documents
* !73 PRJ-366 Changing pages on the main projects list now scrolls the view back to the top
* !96 PRJ-456 Added some protection against rogue data when creating a new blank project with no template

### Bug fixes
* !38 PRJ-334 when a project is created from a template, it will now always correctly inherit the template's cover image
* !80 PRJ-388 Removed unnecessary role copy step when creating a project
* !78 PRJ-384 Marked project description field as a CLOB type for reports to avoid errors when sorting
* !81 PRJ-390 Fixed page blanking issue when trying to filter projects list by "following"
* !65 PRJ-361 Fixed front-end error in the project details page (history tab)

### Breaking Changes
* `Claromentis\Projects\FilesService`
  * Renamed to `\Claromentis\Projects\Service\FilesService`
  * Changed construct argument signature.
  * `GetProjectFolder`
    * Changed argument signature from `Project ID` to `Project`.
    * Changed return signature from `Folder ID` to `ERMSFolder`.
  * Changed `DeleteProjectFiles` argument signature from `Project ID` to `Project`.
  * Changed `GetProjectFileCount` argument signature from `Project ID` to `Project`.
* Changed `Claromentis\Projects\TaskProvider` method `CopyTasksFromProject` argument signature from `Project ID` to `Project`.
* Changed `Claromentis\Projects\Controller\ProjectsController` method `Delete` argument signature from `Application, ServerRequestInterface, mixed` to `SecurityContext, int`.
* Added constructor with parameters to `Claromentis\Projects\Controller\ProjectsController`.
* `Claromentis\Projects\TaskSectionProvider`
  * Renamed to `Claromentis\Projects\Repository\TaskSectionRepository`.
  * Updated constructor parameters.
  * Removed method `DeleteSectionsForProject`.
  * Removed method `DeleteSection`.
* `Claromentis\Projects\TaskProvider`
  * Renamed to `\Claromentis\Projects\Repository\TaskRepository`.
  * Removed method `DeleteTask`.
* Changed `Claromentis\Projects\Controller\TaskController` method `Task`'s parameters.
* Added 4th parameter `Claromentis\Core\DAL\QueryFactory` to `Claromentis\Projects\TaskProvider`.
* `Claromentis\Projects\Controller\TaskSectionController`:
  * Added constructor with parameters.
  * Changed the method `Section`'s parameters.
* There is no longer an `is_complete` column in the `projects_task` table, having been replaced by `status_id`
* `\Claromentis\Projects\View\TaskView::GetUserAdHocTaskPermissions`:
  * Added return type.
  * Updated parameters.

#### Developer notes
* !37 PRJ-73 Added events for role add, role update, role removal, role owner add and role owner removal.
* !50 PRJ-319 Task assignees are now stored in a join table instead of in a column on the task table. This is to enable us to support multiple assignees in future.
* !38 PRJ-334 When creating a project from a template, the template's cover image is now fetched using the CDN API instead of via curl.

## 1.6.3 - 10th May 2021

### Bug fixes
* !84 PRJ-396 Repeatable metadata compatibility in the "My Projects" component
* !99 BT-2397 Fixed projects being saved without filling in a mandatory user picker field (and losing all their metadata as a consequence)

## 1.6.2 - 12th March 2021

### Bug fixes
* !82 BT-2282 DISCO-31973 Fixed module-breaking error when saving a task with a due date before 1000AD

## 1.6.1 - 24th February 2021
* !53 PRJ-341 DISCO-31250 Fixed empty growl message when user added title longer than 255 characters and wrap title text
* !70 BT-1870 Fixed links and tagged users in the notifications for project task discussion
* !72 BT-2242 Fixed 'My Tasks' component only showing one option in its project picker
* !66 REP-1 Added 'project id' column to reports

## 1.6.0 - 20th January 2021
* !34 Added Reports module integration

## 1.5.0 - 17th December 2020

### Improvements
* !17 (PRJ-132) "My Projects" component is now called "Projects" and has options to choose which projects to show and what order to put them in
* !19 (PRJ-134) The "my tasks" component has been changed to allow filtering by project, to be able to show completed tasks, to choose to sort by due date or name, to choose sort direction, and to choose to group the tasks by project.

## 1.4.19 - 30th November 2020
* !33 BT-559 Added missing admin button in projects header

## 1.4.18 - 18th September 2020
* !27 BT-1871 Additional compatibility with Angular 1.5+

## 1.4.17 - 19th August 2020
* !26 BT-1871 Additional compatibility with Angular 1.5+

## 1.4.16 - 16th June 2020
* f19a6975 BT-1620 Disco 027952 Fixed greedy valid object checks that caused errors in other modules

## 1.4.15 - 16th June 2020
* FRAM-368 Made compatible with AngularJs 1.5+

## 1.4.14 - 15th June 2020
### Bug fixes
* !15 BT-1254 Fixed Discussions links displaying as raw text instead of HTML in system notifications and emails
* ccae3125 BT-1620 Disco 027952 Fixed greedy `IsObjectValid()` checks that caused errors in other modules

## 1.4.13 - 27th April 2020
### Bug fixes
* !13 (BT-1240) Fixed empty growl message when user added task not assigned to a project. Method `CanSendProjectNotifications()`
has been called on `null`.

## 1.4.12 - 27th April 2020
* !14 BT-960 Fixed due dates not being saved if the short date format began with the name of a month

## 1.4.11 - 31st March 2020
* History display was broken

## 1.4.10 - 11th February 2020
### Bug fixes
* !11 (BT-1240) Fixed empty growl message when user added task not assigned to a project

## 1.4.9 - 20th December 2019
### Bug fixes
* !8 (CORE-945) Patched XSS vulnerability caused by HTML in history entries.
* !9 (BT-977) encode special uri characters in the project description
* !10 BT-1019 Notifications could be sent sometimes when a project was not live or a template.

## 1.4.8 - 27th November 2019
### Improvements
* CORE-1036 Added Hungarian translation

## 1.4.7 - 29th October 2019
### Improvements
* Added Uzbek translation

## 1.4.6 - 17th October 2019
### Improvements
* !7 CORE-973 Added Component `My Projects` to Category `Productivity & Shortcuts`.
* !7 CORE-973 Added Component `My Tasks` to Category `Productivity & Shortcuts`.
* !7 CORE-974 Added Localized Titles to the following Components:
     * My Projects
     * My Tasks

## 1.4.5
- Fixes from 1.2.13 and 1.3.6
- !6 UIUX-481 Improvements to expected duration label, duration can be blank, duration field validation

## 1.4.4
- Fixes from 1.2.12 and 1.3.5

## 1.4.3
* Added Russian translations and twig templates
* Fixes and improvements merged forward from 1.2 and 1.3

## 1.4.2
* Pages component improvements from 1.3.4

## 1.4.1
* Fix from 1.2.10

## 1.3.6
- Fixes from 1.2.13

## 1.3.5
- !3 (UIUX-240) Added line breaks to comments notification email body
- !3 (UIUX-351) Improved display of RAG labels in app
- Fix from 1.2.12

## 1.3.4
- !2 (UIUX-128) Pages component improvements
  - Removed Value and Services from the component's display
  - Removed Currency and Currency Position from the component's settings
  - Added a background colour to the component's progress bar

## 1.3.3
* Fix from 1.2.10

## 1.2.13
* !6 (BT-576) (UIUX-565) Project list was not in the correct order and pinned projects were not at the start

## 1.2.12
* !5 (CORE-868) Fixed issue where Project admins could only see projects they were a member of

## 1.2.11
* Fixed Project component not displaying the correct number of projects. (Disco 023668, CORE-702)

## 1.2.10
* Project sections could become hidden if re-arranged before it was visible (added by user in another browser for example). (Disco 22949, CORE-535)

## 1.4.0
* Set Compatibility to Claromentis 8.6
* Flagged DMSV as a dependency so that if it gets disabled in the core admin panel it would also disable Projects rather than show errors.

## 1.3.2
* Set Compatibility to Claromentis 8.5 only for this branch.
* Removed DMSV dependancy change from 1.3.1. This should have been done in a new 1.4 branch for compatibility.  

## 1.3.1
* Fix hybrid breadcrumb not working with history items (#20996)
* Some localization work.
* Changing star icon to indicate bookmark to pushpin for pinning to the top (Jira UIUX-60)
* Tidy up column in project edit properties
* Added tooltip to project pin (UIUX-7)
* Added active class for bookmarked discussion (Jira UIUX-246)
* Flagged DMSV as a dependency so that if it gets disabled in the core admin panel it would also disable Projects rather than show errors.

## 1.3.0
* Compatible with Claromentis 8.5
* Layout tidying up and usability improvement for extra wide screen

## 1.2.9
* Projects with empty descriptions caused a JS error and broken workflow when used as a template for a new project. (Disco 22165)

## 1.2.8
* Set compatibility with core to end at Claromentis 8.4
* Layout tidying up and usability improvement for extra wide screen

## 1.2.7
* Re-enabled direct links to discussion tabs from project/task notifications about comments. (#421, Disco 20727)

## 1.2.6
* Composer.json compatibility with future versions of core.

## 1.2.5
* Small change to make file icon on a Task link to the task files tab. (Disco 19920)

## 1.2.4
* Compatibility with Claromentis 8.3
* Added some missing German localisation

## 1.2.3
* Fixed user not receiving notifications when new task is assigned. (#391)

## 1.2.2
* Fixed a bug where editing a project would show markup in the description instead of WYSIWYG text. (#385)
* Editing and submitting a project with no change could send a change notification in some circumstances. (#386)
* Reloading the page when editing a project always returned to the first tab.

## 1.2.1
* All fixes from 1.1.2
* Fixed a conflict with the BBCode component that inserted text on the screen when clicking. (#384)

## 1.1.2
* "Tasks" folder for file storage was case-sensitive. (Disco 18210)
* "Tasks" folder is now recreated if it has been renamed/deleted (#330)
* Updating a project in draft status could occasionally cause an error. (#339)
* Adding a link to a comment incorrectly sent an empty "file added" notification. (Disco 18284, #381)

## 1.2.0
* Minor bugfix on page navigation

## 1.2.0-rc
* Fixed tabs sometimes causing error 404
* Bugfix for task section and tasks display order not updating until a page reload. (#363)
* Added a component option to set the currency symbol and position (left, right of the number).

## 1.1.1
* Bugfix for task section and tasks display order not updating until a page reload. (#363)
* Added a component option to set the currency symbol and position (left, right of the number).

## 1.2.0-beta2
 * DMSV dependency was set to use the Claro 8.1 version.
 * Removed "close" button from admin permissions dialog

## 1.2.0-beta
 * Claromentis 8.2 compatibility.
 * Changes to admin page layouts to make consistent with other modules.
 * Many bugfixes and design improvements.

## 1.0.2
* Bug fix for tasks and sections being temporarily reordered when a task was deleted.

## 1.1.0
* Compatibility with Claromentis 8.1
* Added new image crop tool
* Bugfixes
* Some project description formatting changes (size, line breaks)

## 1.0.1
* Some bug fixes

## 1.0.0
* No changes from 0.3.2

## 0.3.2
* Bug fix for trying to delete files and folders that the user can't access.

## 0.3.1
* Bug fix for imagemagick thumbnail resizing.

## 0.3.0
* Added German translation

## 0.2.2
* Updated to more claro 8 standards.
* Icon change

## 0.2.1
* Bugfixes

## 0.2.0
* Bugfixes and code review
* Some internal code reorganisation

## 0.1.0
Initial release
