define(['./add_list_button.component.html'], function (template)
{
    var DEFAULT_COLOUR = '#aa55cc';

    var addListButton = {
        bindings: {
            onNewList: '&'
        },
        templateUrl: template,
        controller: function () {
            var ctrl = this;
            var modalContainer = angular.element('#add-task-popup');

            ctrl.colour_control = {};

            ctrl.new_list = {
                title: lmsg('projects.task.new_section'),
                colour: DEFAULT_COLOUR
            };

            ctrl.submitList = function ($event) {
                $event.preventDefault();

                ctrl.onNewList({$event: {
                    title: ctrl.new_list.title,
                    colour: ctrl.new_list.colour,
                    onSuccess: function(){
                        angular.element('#add-list-popup').modal('hide');

                        // trigger when list has been added
                        angular.element('#headerButtonsApp').trigger('onAddedList', {});

                        // hide parent modal
                        if (modalContainer.length) {
                            modalContainer.modal('hide');
                        }
                    }
                }});
            };

            ctrl.closeListModal = function () {
                angular.element('#add-list-popup').modal('hide');
            };

            ctrl.startEdit = function($event)
            {
                // Reset form data
                ctrl.new_list.title = lmsg('projects.task.new_section');
                ctrl.new_list.colour = DEFAULT_COLOUR;
                ctrl.colour_control.reset();
            };
        }
    };

    return addListButton;
});
