define(['./add_task_button.component.html'], function (template)
{
    var addTaskButton = {
        bindings: {
            projectId: '<',
            projectDurationUnits: '<',
            lists: '<',
            onNewTask: '&'
        },
        templateUrl: template,
        controller: [
            'projectPreloadFactory',
            '$timeout',
            'claTaskSectionService',
            function (projectPreload, $timeout, taskSectionService) {
                var ctrl = this;
                var modalContainer = angular.element('#add-task-or-list-popup');

                ctrl.userControl = {};
                ctrl.htmlControl = {};

                ctrl.$onInit = function() {
                    angular.element('#headerButtonsApp')
                        .on('onAddedList', function(event, data)
                        {
                            taskSectionService.get(projectPreload.id)
                                .then(function (response) {
                                    ctrl.lists = response;
                                    ctrl.listSelect();
                                });
                        })

                        .on('onDeleteList', function(event, data)
                        {
                            taskSectionService.get(projectPreload.id)
                                .then(function (response) {
                                    ctrl.lists = response;
                                    ctrl.listSelect();
                                });
                        });
                };

                ctrl.reset = function() {
                    ctrl.newTask = {
                        id: 0,
                        project_id: projectPreload.project_id,
                        title: '',
                        description: '',
                        due_date: '',
                        due_date_formatted: '',
                        list_id: ctrl.lists.length > 0 ? ctrl.lists[0].id : null,
                        is_private: false,
                        assignees: [],
                        priority: '0',
                        is_complete: false,
                        duration: '',
                        duration_units: '',
                        comments_count: 0,
                        has_file_storage: false,
                        display_order: 10000,
                        orders: {
                            task: ctrl.DISPLAY_ORDER_NONE,
                            board: ctrl.DISPLAY_ORDER_NONE,
                            board_no_list: ctrl.DISPLAY_ORDER_NONE,
                            my_tasks: ctrl.DISPLAY_ORDER_NONE
                        },
                        status_id: 0,
                        status_list: []
                    };
                };

                ctrl.closeTaskModal = function () {
                    angular.element('#add-task-popup').modal('hide');
                };

                ctrl.submitTask = function ($event) {
                    $event.preventDefault();

                    ctrl.onNewTask({
                        $data: {
                            name: ctrl.newTask.title,
                            description: ctrl.newTask.description,
                            assignees: ctrl.newTask.assignees,
                            due_date: ctrl.newTask.due_date,
                            priority: parseInt(ctrl.newTask.priority),
                            duration: parseInt(ctrl.newTask.duration),
                            is_private: ctrl.newTask.is_private,
                            list_id: parseInt(ctrl.newTask.list_id),
                            onSuccess: function() {
                                angular.element('#add-task-popup').modal('hide');

                                // update field "List" in Add task modal
                                angular.element('#headerButtonsApp').trigger('onAddedList', {});

                                // hide parent modal
                                if (modalContainer.length) {
                                    modalContainer.modal('hide');
                                }
                            }
                        }
                    });
                };

                ctrl.enableEditTaskPriority = function()
                {
                    angular.element('.js-task-edit-priority').each(function()
                    {
                        if (angular.element(this).hasClass('select2-container'))
                            return;

                        // This should be automatic but it is invisible still at this point so not processed yet.
                        angular.element(this).val(ctrl.newTask.priority);

                        ctrl.colourSelect(angular.element(this));
                    });
                };

                ctrl.colourSelect = function(target)
                {
                    target.select2({
                        templateResult: function (data)
                        {
                            if (!data.id) { return data.text; }
                            return '<span class="task-priority-option task-priority-' + data.id + '" style="display:inline-block; margin-right:0;">&nbsp</span> ' + data.text;
                        },
                        templateSelection: function formatPrioritySelection (data)
                        {
                            if (!data.id) { return data.text; }
                            return '<span class="task-priority-option task-priority-' + data.id + '" style="display:inline-block; margin-right:0;">&nbsp</span> ' + data.text;
                        },
                        escapeMarkup: function(markup)
                        {
                            return markup;
                        },
                        minimumResultsForSearch: Infinity, // Hide search box
                        width: "100%"
                    });
                };

                ctrl.listSelect = function()
                {
                    angular.element('.js-task-edit-list').select2({
                        width: "100%"
                    });
                    ctrl.userControl.reset();
                };

                ctrl.startEdit = function($event)
                {
                    ctrl.reset();

                    // Reset form data
                    ctrl.enableEditTaskPriority();

                    // Open CKEditor
                    ctrl.htmlControl.onOpen();

                    // init select2 after ctrl.reset()
                    $timeout(function() {
                        ctrl.listSelect();
                    });
                };

                angular.element('#add-task-popup').on('hidden.bs.modal', function(){
                    ctrl.htmlControl.onClose();
                });
            }
        ]
    };

    return addTaskButton;
});
