define(['./add_list.component.html'], function (template)
{
    var addList = {
        bindings: {},
        templateUrl: template,
        controller: [
            '$timeout',
            '$scope',
            'projectPreloadFactory',
            function ($timeout, $scope, projectPreload) {
                var ctrl = this;

                ctrl.isVisible= false;
                angular.element(document).on('projectsTabChange', function($event, tabName) {
                    ctrl.isVisible = tabName === 'tasks';

                    $timeout(function() {
                        $scope.$digest();
                    }, 0);
                });

                ctrl.$onInit = function() {
                    ctrl.perms = projectPreload.perms;
                };

                ctrl.canAddList = function() {
                    return ctrl.isVisible && ctrl.perms.can_edit_any_task;
                };

                ctrl.addNewList = function (data) {
                    angular.element('#headerButtonsApp').trigger('onAddList', {
                        title: data.title,
                        colour: data.colour,
                        success: data.onSuccess,
                    });
                };
            }
        ]
    };

    return addList;
});
