(function()
{
    var moduleName = 'cla.service.project_details';

    // Manual singleton as the .service() appears to return multiple instances across Angular apps
    var instance = new ProjectDetailsService();

    angular.module(moduleName)
        .service('claProjectDetailsService', function() {
            return instance;
        });

    function ProjectDetailsService()
    {
        var service = this;

        service.currentTab = 'overviewTab';

        service.tabCounts = {
            taskCount: 0,
            totalTaskCount: 0,
            teamCount: 0,
            topicCount: 0,
            fileCount: 0
        };

        service.callbacks = [];

        service.triggerCallbacks = function()
        {
            for (var callbackIndex = 0; callbackIndex < service.callbacks.length; callbackIndex++)
            {
                (service.callbacks[callbackIndex])({
                    tab: service.currentTab,
                    counts: service.tabCounts
                });
            }
        };

        service.setLocation = function(location)
        {
            service.currentTab = location;

            service.triggerCallbacks();
        };

        service.getLocation = function()
        {
            return service.currentTab;
        };

        service.registerCallback = function(callback)
        {
            service.callbacks.push(callback);
        };

        service.setTaskCount = function(count, totalCount) {
            service.tabCounts.taskCount = count;
            service.tabCounts.totalTaskCount = totalCount;

            service.triggerCallbacks();
        };

        service.setTeamCount = function(count) {
            service.tabCounts.teamCount = count;

            service.triggerCallbacks();
        };

        service.setTopicCount = function(count) {
            service.tabCounts.topicCount = count;

            service.triggerCallbacks();
        };

        service.setFileCount = function(count) {
            service.tabCounts.fileCount = count;

            service.triggerCallbacks();
        };
    }
}());
