<?php
namespace Claromentis\Projects;

$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"] = (@$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"] ?: array()) + array("_5159b3572" . "969eca46ac" . "d1b2e14184" . "59c" => base64_decode("aW1wbG9" . "kZQ=="), "_7009d8ac1de558444e8eb803cb" . "124671" => base64_decode("cHJvamVjdF9y" . "ZWY="), "_7d937ce" . "5b1d3bea" . "4b5e86fb" . "f0b97759" . "2" => base64_decode("RmFpbGVkIHRvIERlbGV0ZSBUYXNrIFNlY3Rpb25zLCBhcmd1bWVudCBtdXN0IG" . "JlIGFuIGFycmF5IG9mIFRhc2sgU2VjdGlvbnM="), "_1ac5cc48c34c53" . "62e94d8667cc7b0" . "ddc" => base64_decode("LA=" . "="), "_0c1946e" . "18542a70" . "d6c48cd2" . "a965481d" . "d" => base64_decode("Zmlyc3RuYW1lLHN1cm5hbWU" . "="), "_f71cfc2b0" . "aa1c256864" . "03eb153c4d" . "10a" => base64_decode("RmFpbGVkIHRvIG" . "RlbGV0ZSBQcm9q" . "ZWN0J3MgQ292ZX" . "IgSW1hZ2U="), "_0ea4e32b57963ac" . "0cb3057e03e9aef6" . "4" => base64_decode("a" . "W" . "Q" . "="), "_b0c637a8f60acc3ff" . "444ef084184d9e0" => base64_decode("T" . "1" . "I" . "="), "_b7cf44e509d748c74" . "4fc283a50922fb3" => base64_decode("cHJvamVjdF" . "9uYW1l"), "_93939227a8e7" . "cf780efaa642c" . "3da9723" => base64_decode("YnlfdX" . "Nlcl9p" . "ZA=="), "projec" . "t_id" => base64_decode("cHJva" . "mVjdF" . "9pZA=" . "="));
use Analogue\ORM\EntityCollection;
use Claromentis\Core\Acl\RoleBased\RoleAclChecker;
use Claromentis\Core\CDN\CDNException;
use Claromentis\Core\Event\EventDispatcher;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\People;
use Claromentis\People\Filter\UserFilter;
use Claromentis\People\UseCase\GetUser;
use Claromentis\People\UseCase\GetUsers;
use Claromentis\Projects\Entity\TaskStatus;
use Claromentis\Projects\Event\ProjectEvent;
use Claromentis\Projects\Event\ProjectPostDeletedEvent;
use Claromentis\Projects\Event\ProjectPreDeleteEvent;
use Claromentis\Projects\Exceptions\ProjectException;
use Claromentis\Projects\Exceptions\ProjectFolderException;
use Claromentis\Projects\Exceptions\ProjectsFolderException;
use Claromentis\Projects\Exceptions\TaskSectionException;
use Claromentis\Projects\Exceptions\TasksFolderException;
use Claromentis\Projects\Repository\TaskStatusRepository;
use Claromentis\Projects\Repository\TopicRepository;
use Claromentis\Projects\Model\Project;
use Claromentis\Projects\Repository\ProjectRepository;
use Claromentis\Projects\Service\FilesService;
use Claromentis\Projects\UseCase\DeleteProjectRoles;
use Claromentis\Projects\Service\NotificationService;
use Claromentis\Projects\ProjectEvent as LegacyProjectEvent;
use ERMSFolder;
use InvalidArgumentException;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;
class ProjectApi implements LoggerAwareInterface
{
    use LoggerAwareTrait;
    
    
    
    
    private $topic_repository;
    
    
    
    private $delete_project_roles;
    
    
    
    
    private $event_dispatcher;
    
    
    
    
    private $files_service;
    
    
    
    
    private $get_users;
    
    
    
    
    private $people_api;
    
    
    
    
    private $permissions_map;
    
    
    
    
    private $project_repo;
    
    
    
    
    private $role_checker;
    
    
    
    
    private $task_api;
    
    
    
    
    private $extranets;
    
    
    
    
    protected TaskStatusRepository $task_status_repository;
    
    
    
    
    protected TaskStatusApi $task_status_api;
    public function __construct(ProjectRepository $_ebfb7629e898d0545f54221697853ab7, PermissionsMap $permissions_map, FilesService $files_service, TaskApi $task_api, People\Api $_59fb944d6b563561f259628d266af1e4, GetUsers $_1f0922a0841eaecec679c8e0ce901176, RoleAclChecker $_69bc53c7d9123f37c29a7ff7311251f4, DeleteProjectRoles $_dae6d61661f975048df346bef8a3c0a0, EventDispatcher $_ff02e5b615810bd1b3c4c27c51e35daa, TopicRepository $_018eed6448abbc8c4aae90cde2897af1, People\Service\UserExtranetService $extranets, TaskStatusRepository $_f057ae1642e75538116b15db7ebc17dc, TaskStatusApi $_5a4dfbd0ee10896f0e5e7c5b1edc2531)
    {
        $this->project_repo = $_ebfb7629e898d0545f54221697853ab7;
        $this->permissions_map = $permissions_map;
        $this->files_service = $files_service;
        $this->task_api = $task_api;
        $this->people_api = $_59fb944d6b563561f259628d266af1e4;
        $this->get_users = $_1f0922a0841eaecec679c8e0ce901176;
        $this->role_checker = $_69bc53c7d9123f37c29a7ff7311251f4;
        $this->delete_project_roles = $_dae6d61661f975048df346bef8a3c0a0;
        $this->event_dispatcher = $_ff02e5b615810bd1b3c4c27c51e35daa;
        $this->topic_repository = $_018eed6448abbc8c4aae90cde2897af1;
        $this->extranets = $extranets;
        $this->task_status_repository = $_f057ae1642e75538116b15db7ebc17dc;
        $this->task_status_api = $_5a4dfbd0ee10896f0e5e7c5b1edc2531;
        $this->logger = new NullLogger();
    }
    
    
    
    
    
    
    
    
    public function GetProject(int $project_id) : Project
    {
        $project = $this->project_repo->GetProject($project_id);
        if (!$project instanceof Project) {
            throw ProjectException::NotFound($project_id);
        }
        return $project;
    }
    
    
    
    
    
    
    
    
    
    public function GetProjectFolder(Project $project) : ERMSFolder
    {
        return $this->files_service->GetProjectFolder($project);
    }
    
    
    
    
    
    
    
    
    
    
    public function GetProjectTasksFolder(Project $project) : ERMSFolder
    {
        return $this->files_service->GetProjectTasksFolder($this->GetProjectFolder($project));
    }
    
    
    
    
    
    
    
    public function GetProjectTaskSections(Project $project) : array
    {
        return $this->task_api->GetProjectsTasksSections([(int) $project->GetId()]);
    }
    
    
    
    
    
    
    public function GetTaskSection(int $_5407d3f080057fdb56f81ba2459e41cd) : TaskSection
    {
        return $this->task_api->GetTaskSection($_5407d3f080057fdb56f81ba2459e41cd);
    }
    
    
    
    
    
    public function GetTaskSections(array $_32913dcf218a260ce6a59ca21a5aa515) : array
    {
        return $this->task_api->GetTaskSections($_32913dcf218a260ce6a59ca21a5aa515);
    }
    
    
    
    
    
    
    
    
    
    
    public function CreateAndSaveProjectFolders(Project $project) : ERMSFolder
    {
        return $this->files_service->CreateAndSaveProjectFolders($project);
    }
    
    
    
    
    
    
    
    
    
    public function RenameProjectFolder(Project $project) : void
    {
        $_3b4d198687ee5a112b0379b490d1564c = $this->GetProjectFolder($project);
        $this->files_service->RenameFolder($_3b4d198687ee5a112b0379b490d1564c, $this->files_service->BuildProjectFolderName($project));
        $this->files_service->SaveFolder($_3b4d198687ee5a112b0379b490d1564c);
    }
    
    
    
    
    
    
    
    
    public function DeleteProject(Project $project, SecurityContext $context) : void
    {
        $project_id = (int) $project->GetId();
        if (!$this->permissions_map->PermitsProjectAction($context, $project_id, Permissions::DELETE_PROJECT)) {
            throw ProjectException::NoDeletePermission($context->GetFullName(), $project->GetName());
        }
        $_e62ca7bbb93b52cafc82da1c2aefe9ec = new ProjectPreDeleteEvent($project);
        $_e62ca7bbb93b52cafc82da1c2aefe9ec->SetData([$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["projec" . "t_id"] => $project_id, $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_b7cf44e" . "509d748c" . "744fc283" . "a50922fb" . "3"] => $project->GetName(), $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_7009d8ac1de5" . "58444e8eb803c" . "b124671"] => $project->GetReference(), $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_93939227a8e7cf780efaa642c3da9" . "723"] => $context->GetUserId()]);
        $this->event_dispatcher->dispatch(ProjectPreDeleteEvent::NAME, $_e62ca7bbb93b52cafc82da1c2aefe9ec);
        if ($_e62ca7bbb93b52cafc82da1c2aefe9ec->isPropagationStopped()) {
            return;
        }
        $this->delete_project_roles->DeleteProjectRoles($project_id);
        $this->DeleteProjectTaskSections($project, $context);
        $this->topic_repository->deleteForProjectId($project_id);
        try {
            $this->project_repo->DeleteProject($project_id);
        } catch (CDNException $_c35473364fa7a050299058f332ec29c1) {
            $this->logger->error($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_f71cfc2b0aa1c25686" . "403eb153c4d10a"], [$_c35473364fa7a050299058f332ec29c1]);
        }
        
        
        $this->files_service->DeleteProjectFiles($project);
        $this->files_service->SendNotifications();
        
        
        $this->event_dispatcher->dispatch(ProjectPostDeletedEvent::NAME, $_e62ca7bbb93b52cafc82da1c2aefe9ec);
    }
    
    
    
    
    
    
    
    public function DeleteProjectTaskSections(Project $project, SecurityContext $context) : void
    {
        $this->task_api->DeleteTaskSections($this->GetProjectTaskSections($project), $context);
    }
    
    
    
    
    
    
    
    
    public function DeleteTaskSection(TaskSection $_be9f37bd560ea9fd00c071ec2fc0d922, SecurityContext $context) : void
    {
        $this->DeleteTaskSections([$_be9f37bd560ea9fd00c071ec2fc0d922], $context);
    }
    
    
    
    
    
    
    
    
    public function DeleteTaskSections(array $_56786685529ed013bdc8a5e3bb5ff230, SecurityContext $context) : void
    {
        foreach ($_56786685529ed013bdc8a5e3bb5ff230 as $_be9f37bd560ea9fd00c071ec2fc0d922) {
            if (!$_be9f37bd560ea9fd00c071ec2fc0d922 instanceof TaskSection) {
                throw new InvalidArgumentException($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_7d937ce5b1d3bea4b5e86fbf" . "0b977592"]);
            }
            if (!$this->permissions_map->PermitsProjectAction($context, $_be9f37bd560ea9fd00c071ec2fc0d922->GetOwnerId(), Permissions::EDIT_ANY_TASK)) {
                throw TaskSectionException::NoDeletePermission($context->GetFullName(), $_be9f37bd560ea9fd00c071ec2fc0d922->GetName());
            }
        }
        $this->task_api->DeleteTaskSections($_56786685529ed013bdc8a5e3bb5ff230, $context);
    }
    
    
    
    
    
    
    
    public function GetPermissionsChecker(SecurityContext $context)
    {
        return new PermissionsChecker($this->permissions_map, $context, $this->extranets);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function GetUsersWithRights(SecurityContext $context, int $project_id, int $_a48eb1db4f6ab2c82fb9db687c5f4a32, int $_f11369824f533e8206f9ccc0c9aab3a0, int $_1f50e30be8c2fefa6881834e71d504a2, ?string $_8dabb06efc95df4cff7c4afe91857b53 = null, ?string $_f6a16426f3b3f03ad6bacec912eec291 = null, string $_faeb739cfde8d2db25789d857259b877 = 'asc') : array
    {
        $_7945aa6526b98d01ea0f6f6f7037bd6e = new UserFilter($context);
        
        
        if ($project_id) {
            $_17247f55ce15f647f57c3ef8bb3a474a = $this->role_checker->GetUsersWithRight(Permissions::PROJECT_AGGREGATION, $project_id, $_a48eb1db4f6ab2c82fb9db687c5f4a32);
            if (empty($_17247f55ce15f647f57c3ef8bb3a474a)) {
                return [new EntityCollection(), 0];
            }
            $_7945aa6526b98d01ea0f6f6f7037bd6e->SetIds($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_5159b3572969e" . "ca46acd1b2e141" . "8459c"]($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_1ac5cc48c34c5362e94d86" . "67cc7b0ddc"], $_17247f55ce15f647f57c3ef8bb3a474a));
        }
        if (isset($_8dabb06efc95df4cff7c4afe91857b53)) {
            $_7945aa6526b98d01ea0f6f6f7037bd6e->SetQueryFields($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_0c1946e18542a70d6" . "c48cd2a965481dd"]);
            $_7945aa6526b98d01ea0f6f6f7037bd6e->SetQueryType($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_b0c637a8f" . "60acc3ff44" . "4ef084184d" . "9e0"]);
            $_7945aa6526b98d01ea0f6f6f7037bd6e->SetQuery($_8dabb06efc95df4cff7c4afe91857b53);
        }
        if ($_f11369824f533e8206f9ccc0c9aab3a0 > 0) {
            $_7945aa6526b98d01ea0f6f6f7037bd6e->SetLimit($_f11369824f533e8206f9ccc0c9aab3a0);
        }
        if ($_1f50e30be8c2fefa6881834e71d504a2 > 0) {
            $_7945aa6526b98d01ea0f6f6f7037bd6e->SetOffset($_1f50e30be8c2fefa6881834e71d504a2);
        }
        if (!isset($_f6a16426f3b3f03ad6bacec912eec291)) {
            $_f6a16426f3b3f03ad6bacec912eec291 = $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_5159b357" . "2969eca46" . "acd1b2e14" . "18459c"]($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_1ac5cc4" . "8c34c536" . "2e94d866" . "7cc7b0dd" . "c"], $this->people_api->GetUserNameDisplayFields());
        }
        $_7945aa6526b98d01ea0f6f6f7037bd6e->SetSort($_f6a16426f3b3f03ad6bacec912eec291);
        $_7945aa6526b98d01ea0f6f6f7037bd6e->SetSortDirection($_faeb739cfde8d2db25789d857259b877);
        return $this->get_users->GetUsers($_7945aa6526b98d01ea0f6f6f7037bd6e);
    }
    public function ProjectExists(int $project_id) : bool
    {
        $project = $this->project_repo->GetProject($project_id);
        return $project !== null;
    }
    
    
    
    
    
    
    
    
    
    
    public function CopyAndSaveStatuses(Project $_ea389ff409b87715c72e4ecf57917ce5, Project $_7c0f893ab0c95907c78e38e1c354b301) : array
    {
        $project_id = $_ea389ff409b87715c72e4ecf57917ce5->GetId();
        $statuses = $this->task_status_repository->getProjectStatuses($_7c0f893ab0c95907c78e38e1c354b301);
        $_52aa25a0d6921da588fe80bb30c0e12c = [];
        if (empty($statuses)) {
            return $_52aa25a0d6921da588fe80bb30c0e12c;
        }
        foreach ($statuses as $status) {
            $_ed9e26151db293a5d9b6cf0bc61ee2f4 = new TaskStatus();
            $_ed9e26151db293a5d9b6cf0bc61ee2f4->project_id = $project_id;
            $_ed9e26151db293a5d9b6cf0bc61ee2f4->sort_order = $status->sort_order;
            $_ed9e26151db293a5d9b6cf0bc61ee2f4->name = $status->name;
            $this->task_status_api->SaveStatus($_ed9e26151db293a5d9b6cf0bc61ee2f4);
            $_52aa25a0d6921da588fe80bb30c0e12c[$status[$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_0ea4e32b57963ac0cb3057e0" . "3e9aef64"]]] = $_ed9e26151db293a5d9b6cf0bc61ee2f4->id;
        }
        return $_52aa25a0d6921da588fe80bb30c0e12c;
    }
}