(function()
{
	var moduleName = 'claromentis.project';
	var module;

	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module
		.factory('TaskSection', ['$http', 'Task', taskSectionFactory]);

	function taskSectionFactory($http, Task)
	{
		var TaskSection = function()
		{
			this.new_task = new Task();

			this.id = 0;
			this.project_id = 0;
			this.title = '';
			this.display_order = 0;
			this.colour = '#ccddee';
			this.style = {'background-color': '#ccddee'};
			this.expanded = true;

			this.editCopy =
			{
				title: this.title
			};

			this.new_task = {};
		};

		TaskSection.prototype =
		{
			restUrl: '/api/projects/task/section/',

			loadFromArray: function(data)
			{
				this.id = data.id;
				this.project_id = data.project_id;
				this.title = data.title;
				this.display_order = data.display_order;
				this.colour = data.colour;
				this.style = {'background-color': data.colour};
			},
			makeEditCopy: function()
			{
				this.editCopy =
				{
					title: this.title,
					colour: this.colour
				};
			},
			add: function(successCallback, errorCallback)
			{
				var data =
				{
					project_id: this.project_id,
					title: this.title,
					colour: this.colour,
					display_order: this.display_order
				};
				$http(
					{
						method:'POST',
						url: this.restUrl + 'add',
						data: data,
						section: this,
						successCallback: successCallback,
						errorCallback: errorCallback
					}).then(function(response)
                    {
                        var section = response.config.section;
                        section.id = response.data.id;
                        section.project_id = response.data.project_id;
                        section.title = response.data.title;
                        section.colour = response.data.colour;
                        section.style = {'background-color': response.data.colour};
                        section.display_order = response.data.display_order;

                        response.config.successCallback(response.data);
                    }, function(response)
                    {
                        response.config.errorCallback(response.data);
					});
			},
			update: function(successCallback, errorCallback)
			{
				var data =
				{
					title: this.editCopy.title,
					colour: this.editCopy.colour,
					project_id: this.project_id,
					display_order: this.display_order
				};
				$http(
					{
						method:'PUT',
						url: this.restUrl + this.id,
						data: data,
						section: this,
						successCallback: successCallback,
						errorCallback: errorCallback
					}).then(function(response)
                    {
                        var section = response.config.section;
                        section.id = response.data.id;
                        section.project_id = response.data.project_id;
                        section.title = response.data.title;
                        section.colour = response.data.colour;
                        section.style = {'background-color': response.data.colour};
                        section.display_order = response.data.display_order;

                        response.config.successCallback(response.data);
                    }, function(response)
                    {
                        response.config.errorCallback(response.data);
					});
			},
			delete: function(successCallback, errorCallback)
			{
				$http(
					{
						method:'DELETE',
						url: this.restUrl + this.id,
						section: this,
						successCallback: successCallback,
						errorCallback: errorCallback
					}).then(function(response)
                    {
                        response.config.successCallback(response.data.id);
                    }, function(response)
                    {
                        response.config.errorCallback(response.data);
					});
			},
			setDisplayOrder: function(display_order)
			{
				this.display_order = display_order;
			}
		};

		return TaskSection;
	}
}());
