define([
    './directive/user_picker.directive.js',
    './component/toggle_switch.component.js',
    './component/confirm.component.js',
    './component/user_list.component.js',
    './component/user_list_item.component.js',
    './component/users_list_popup.component.js',
    './component/checkbox.component.js',
    './service/confirm.service.js',
    './service/user_list.service.js',
    '../../../../node_modules/angular-utils-pagination/dirPagination.js',
    './css/user_list.component.scss'

], function (
    UserPicker,
    ToggleSwitch,
    Confirm,
    UserList,
    UserListItem,
    UsersListPopup,
    Checkbox,
    ConfirmService,
    UserListService
) {
    return angular
        .module('claromentis.projects.widgets', ['angularUtils.directives.dirPagination'])
        .directive('clangProjectsUserPicker', UserPicker)
        .component('clangToggleSwitch', ToggleSwitch)
        .component('clangConfirm', Confirm)
        .component('clangUserList', UserList)
        .component('clangUserListItem', UserListItem)
        .component('clangUsersListPopup', UsersListPopup)
        .component('clangCheckbox', Checkbox)
        .service('confirmService', ConfirmService)
        .service('userListService', UserListService);
});
