(function()
{
    var template = require('../../html/project/tasks.list_type.directive.html');
    var moduleName = 'claromentis.project';

    angular.module(moduleName)
        .directive('clangTasksListType', tasksListType);

    tasksListType.$inject = ['$rootScope'];
    function tasksListType($rootScope) {
        return {
            restrict: 'E',
            require: '^ngModel',
            templateUrl: template,
            scope: {
                ngModel: '='
            },
            transclude: true,
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            this.$onInit = function() {
                if ((ctrl.ngModel !== 'list') &&
                    (ctrl.ngModel !== 'board'))
                {
                    ctrl.ngModel = 'list';
                }
            };

            ctrl.changeView = function(view, $event)
            {
                $event.preventDefault();

                ctrl.ngModel = view === 'list' ? 'list' : 'board';

                // Pass view mode now so that the new data can be built correctly before the end of the digest
                $rootScope.$broadcast('task_list_data.updated', {view: ctrl.ngModel});
            };
        }
    }
}());
