<?php
namespace Claromentis\Projects\Controller;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"] ?: array()) + array("_1bee3d4d1" . "d0df49e0fc" . "f8b9ed2ecb" . "8fa" => base64_decode("ZXhwb" . "G9kZQ" . "=="), "_25867e3e3db289692" . "53f3a370c3166ba" => base64_decode("ZGVz" . "Yw=="), "_18c93a32ba5fa" . "f9509389a94787" . "e6798" => base64_decode("bW9kaWZp" . "ZWQ="), "_a71dc9333bd8ad95d55d6624b4778" . "75f" => base64_decode("ZGF0" . "YQ=="), "_8ab6ddf42088608c501fcded89" . "95e76c" => base64_decode("I" . "A" . "=" . "="), "_f1136982" . "4f533e820" . "6f9ccc0c9" . "aab3a0" => base64_decode("bGltaXQ" . "="), "_0290d5279a73376ebff811" . "c191d735a6" => base64_decode("c29ydF9ka" . "XI="), "_ea8229a121285ee649a72fd880bac" . "39b" => base64_decode("YXJyYXlfZmlsdG" . "Vy"), "_f4eafa5f493306ffdb" . "51a688b21dd507" => base64_decode("dG90" . "YWw="), "_7af8fa1543a4f2c3d3e6350f7f0c4" . "fcd" => base64_decode("YX" . "Nj"), "_4d707fa" . "b93bebb0" . "0bbe69e8" . "159697c9" . "0" => base64_decode(""), "_206f063cdbd" . "5801a283704e" . "f0c883699" => base64_decode("a2V5d29yZHM" . "="), "_f6a16426f3b3f0" . "3ad6bacec912eec" . "291" => base64_decode("c29y" . "dA=="), "_1f50e30be8c2fefa688" . "1834e71d504a2" => base64_decode("b2Zmc" . "2V0"), "_b1767a8" . "4b84eaf3" . "919b918b" . "d13dd4fd" . "d" => base64_decode("dG9waWNfcGlub" . "mVk"));
use Claromentis\Core\Http\JsonPrettyResponse;
use Claromentis\Core\Http\RequestData;
use Claromentis\Core\Http\StatusCode;
use Claromentis\Core\REST\RestFormatter;
use Claromentis\Core\Security\Exception\AccessDeniedException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Projects\Api\TopicApi;
use Claromentis\Projects\Dialog\TopicDialog;
use Claromentis\Projects\Entity\Topic;
use Claromentis\Projects\PermissionsChecker;
use Claromentis\Projects\Repository\ProjectRepository;
use Psr\Http\Message\ServerRequestInterface;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;




class TopicRestController
{
    
    
    
    
    protected $project_provider;
    
    
    
    
    protected $topic_api;
    
    
    
    
    protected $format;
    
    
    
    
    protected $dialog;
    public function __construct(ProjectRepository $project_repository, TopicApi $topic_api, RestFormatter $format, TopicDialog $dialog)
    {
        $this->project_provider = $project_repository;
        $this->topic_api = $topic_api;
        $this->format = $format;
        $this->dialog = $dialog;
    }
    public function ShowList(PermissionsChecker $permissions_checker, RequestData $request_data, int $project_id)
    {
        $project = $this->project_provider->GetProject($project_id);
        if ($project === null) {
            throw new NotFoundHttpException();
        }
        if (!$project->CanIViewAllTopics($permissions_checker)) {
            throw new AccessDeniedException();
        }
        $_f6a16426f3b3f03ad6bacec912eec291 = $request_data->Get($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_f6a16426f3b3f03ad6bacec912" . "eec291"], $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_18c93a32ba5fa" . "f9509389a94787" . "e6798"]);
        $_0290d5279a73376ebff811c191d735a6 = $request_data->Get($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_0290d5279a7" . "3376ebff811c" . "191d735a6"], $_f6a16426f3b3f03ad6bacec912eec291 === $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_18c93a32ba5faf" . "9509389a94787e6" . "798"] ? $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_25867e3e3db28969253f3a370c31" . "66ba"] : $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_7af8fa1543a4f2c3d3e63" . "50f7f0c4fcd"]);
        $_206f063cdbd5801a283704ef0c883699 = $this->GetKeywords($request_data);
        $_e14537bb3cca32e664b153d5ceb1ef47 = $this->topic_api->GetTopics($project_id, $_f6a16426f3b3f03ad6bacec912eec291, $_0290d5279a73376ebff811c191d735a6, $request_data->Get($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_f11369824f533e8206f9ccc0c9aab3" . "a0"], 20), $request_data->Get($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_1f50e30be8" . "c2fefa68818" . "34e71d504a2"], 0), $_206f063cdbd5801a283704ef0c883699);
        $_f4eafa5f493306ffdb51a688b21dd507 = $this->topic_api->CountTopics($project_id, $_206f063cdbd5801a283704ef0c883699);
        $_cfcf180dac4148ce727d28c28880806e = [];
        foreach ($_e14537bb3cca32e664b153d5ceb1ef47 as $topic) {
            $_cfcf180dac4148ce727d28c28880806e[] = $this->dialog->ShowJson($topic);
        }
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_a71dc9333bd8a" . "d95d55d6624b47" . "7875f"] => $_cfcf180dac4148ce727d28c28880806e, $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_f4eafa5f493306ffdb" . "51a688b21dd507"] => $_f4eafa5f493306ffdb51a688b21dd507]);
    }
    public function Show(PermissionsChecker $permissions_checker, Topic $topic, int $project_id)
    {
        $project = $this->project_provider->GetProject($topic->project_id);
        if ($topic->project_id !== $project_id) {
            throw new NotFoundHttpException();
        }
        if (!$project->CanIViewTopic($permissions_checker, $topic)) {
            throw new AccessDeniedException();
        }
        return new JsonPrettyResponse($this->dialog->ShowJson($topic));
    }
    public function Update(PermissionsChecker $permissions_checker, int $project_id, Topic $topic, SecurityContext $context, ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6)
    {
        $_231341bedbbeea0ba9fa8da63ef63dc1 = !$topic->id;
        $project = $this->project_provider->GetProject($project_id);
        if ($topic->project_id && $topic->project_id !== $project_id) {
            throw new NotFoundHttpException();
        }
        if (!$project->CanIEditTopic($permissions_checker, $topic)) {
            throw new AccessDeniedException();
        }
        $_ed5f03d686c37933b5943f295c6b4a43 = $this->format->GetJson($_b791059c94b285cdf1c90ca6f3a8f2a6);
        $_0918e1b00a3c23a7eb313ecb5b7471a1 = $this->dialog->TopicDataFromJson($_ed5f03d686c37933b5943f295c6b4a43, $context, $project_id);
        if (isset($_0918e1b00a3c23a7eb313ecb5b7471a1[$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_b1767a84b84eaf3919" . "b918bd13dd4fdd"]]) && !$project->CanIPinTopic($permissions_checker, $topic)) {
            throw new AccessDeniedException();
        }
        $this->topic_api->Update($topic, $_0918e1b00a3c23a7eb313ecb5b7471a1);
        return new JsonPrettyResponse($this->dialog->ShowJson($topic), $_231341bedbbeea0ba9fa8da63ef63dc1 ? StatusCode::CREATED : StatusCode::OK);
    }
    public function Delete(PermissionsChecker $permissions_checker, int $project_id, Topic $topic)
    {
        $project = $this->project_provider->GetProject($project_id);
        if ($topic->project_id && $topic->project_id !== $project_id) {
            throw new NotFoundHttpException();
        }
        if (!$project->CanIEditTopic($permissions_checker, $topic)) {
            throw new AccessDeniedException();
        }
        $this->topic_api->Delete($topic);
        return new JsonPrettyResponse($this->dialog->ShowJson($topic));
    }
    protected function GetKeywords(RequestData $request_data)
    {
        $_028f0444215be3fb127b022ccc085771 = $request_data->Get($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_206f063cdbd5801a283704ef0c88" . "3699"], $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_4d707fab93bebb00bbe" . "69e8159697c90"]);
        if (empty($_028f0444215be3fb127b022ccc085771)) {
            return [];
        }
        return $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_ea8229a121285" . "ee649a72fd880b" . "ac39b"]($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_1bee3d4d1d0df49e0fcf8b9e" . "d2ecb8fa"]($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_8ab6ddf42" . "088608c501" . "fcded8995e" . "76c"], $_028f0444215be3fb127b022ccc085771));
    }
}