var myProjectsLoaded = myProjectsLoaded || false;

(function()
{
	var moduleName = 'claromentis.project';
	var module;

	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, ['cla.core.lmsg']);
	}

	if (!myProjectsLoaded)
	{
		module
			.directive('projectMyProjects', ['$timeout', projectMyProjects]);

		function projectMyProjects($timeout)
		{
			return {
				restrict: 'E',
				templateUrl: '/intranet/projects/html/components/project_item_dir.html',
				scope: {
					projects: '=',
					currency: '=',
					columns: '='
				},
				controllerAs: 'myProjects',
				bindToController: true,
				controller: controller
			};

			function controller()
			{
                var ctrl = this;

                this.$onInit = function () {
                    ctrl.all_projects = ctrl.projects;

                    for (var i = 0; i < ctrl.all_projects.length; i++) {
                        ctrl.all_projects[i].progress_text = ctrl.all_projects[i].progress + lmsg('projects.progress_bar.percent_complete');

                        // Make IE start off with the right sized progress bar
                        $timeout(function (id, progress) {
                            angular.element('#progress-bar-' + id).css('width', progress + '%');
                        }, 0, true, ctrl.all_projects[i].id, ctrl.all_projects[i].progress);
                    }
                };
			}
		}
	}

	myProjectsLoaded = true;
}());
